/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.block.tile;

import com.github.jarva.arsadditions.common.block.WarpNexus;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.hollingsworth.arsnouveau.api.registry.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.api.util.IWololoable;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.SingleItemTile;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.Vec2;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WarpNexusTile
extends SingleItemTile
implements GeoBlockEntity,
ITickable,
IWololoable {
    private static final RawAnimation CLOSE = RawAnimation.begin().then("spin", Animation.LoopType.PLAY_ONCE).thenPlayAndHold("close");
    private static final RawAnimation OPEN = RawAnimation.begin().thenPlay("open").thenLoop("spin");
    private static final RawAnimation CLOSED = RawAnimation.begin().thenPlayAndHold("closed");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean hasNearbyPlayer = false;
    private boolean hasOpened = false;
    public AnimationController<WarpNexusTile> controller;
    private ParticleColor color = ParticleColor.defaultParticleColor();

    public WarpNexusTile(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)AddonBlockRegistry.WARP_NEXUS_TILE.get(), pos, blockState);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        ItemStack scroll = super.removeItemNoUpdate(pSlot);
        scroll.update((Supplier)DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(null, null, null, true), data -> new WarpScrollData(Optional.of(this.getBlockPos().north(2)), this.getLevel().dimension().location().toString(), Vec2.ZERO, true));
        return scroll;
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        if (this.getBlockState().getValue(WarpNexus.HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        if (level.getGameTime() % 10L == 0L) {
            Player player = level.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 5.0, false);
            this.hasNearbyPlayer = player != null;
        }
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.color = ParticleColorRegistry.from((CompoundTag)tag.getCompound("color"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.put("color", (Tag)this.color.serialize());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = super.getUpdateTag(pRegistries);
        this.saveAdditional(tag, pRegistries);
        return tag;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        this.controller = new AnimationController((GeoAnimatable)this, this::predicate);
        controllerRegistrar.add(this.controller);
    }

    private <E extends BlockEntity> PlayState predicate(AnimationState<E> event) {
        if (event.getController().getCurrentAnimation() == null || !this.hasNearbyPlayer && !this.hasOpened) {
            return event.setAndContinue(CLOSED);
        }
        if (this.hasNearbyPlayer) {
            this.hasOpened = true;
            return event.setAndContinue(OPEN);
        }
        return event.setAndContinue(CLOSE);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setColor(ParticleColor color) {
        this.color = color;
        this.setChanged();
    }

    public ParticleColor getColor() {
        return this.color;
    }

    public static Optional<WarpNexusTile> getWarpNexus(Level level, BlockPos pos) {
        Optional be = level.getBlockEntity(pos, (BlockEntityType)AddonBlockRegistry.WARP_NEXUS_TILE.get());
        return be.flatMap(tile -> tile.getBlockState().getValue(WarpNexus.HALF) == DoubleBlockHalf.UPPER ? level.getBlockEntity(pos.below(), (BlockEntityType)AddonBlockRegistry.WARP_NEXUS_TILE.get()) : Optional.of(tile));
    }
}

