/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.fastsuite;

import dev.shadowsoffire.fastsuite.AuxRecipeManager;
import dev.shadowsoffire.fastsuite.CachedRecipeList;
import dev.shadowsoffire.fastsuite.StreamUtils;
import dev.shadowsoffire.placebo.config.Configuration;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fastsuite")
public class FastSuite {
    public static final String MODID = "fastsuite";
    public static final Logger LOGGER = LogManager.getLogger((String)"fastsuite");
    public static boolean DEBUG = false;
    public static final int MIN_SIZE_REQUIRED_FOR_THREADING = 100;
    public static final boolean DEBUG_MATCHING = "on".equalsIgnoreCase(System.getenv("FASTSUITE_DEBUG_MATCHING"));
    public static int maxRecipeLookupTime = 25;
    public static Set<RecipeType<?>> singleThreadedLookups = new HashSet();
    public static boolean lockInputStacks = false;
    public static boolean unsafeMode = false;

    public FastSuite(IEventBus bus) {
        StreamUtils.setup(this);
        bus.register((Object)this);
        if (DEBUG) {
            NeoForge.EVENT_BUS.addListener(this::test);
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        String[] stLookups;
        Configuration cfg = new Configuration(MODID);
        cfg.setTitle("FastSuite Configuration");
        for (String s : stLookups = cfg.getStringList("Single Threaded Recipe Types", "general", new String[0], "A list of recipe types which may only be looked up on the main thread. Add a recipe type to this list if errors start happening.")) {
            try {
                singleThreadedLookups.add((RecipeType)BuiltInRegistries.RECIPE_TYPE.get(ResourceLocation.parse((String)s)));
            }
            catch (Exception ex) {
                LOGGER.error("Invalid single threaded recipe type name {} will be ignored.", (Object)s);
            }
        }
        maxRecipeLookupTime = cfg.getInt("Max Recipe Lookup Time", "general", maxRecipeLookupTime, 1, 300, "The max time, in seconds, that a recipe lookup may take before aborting the lookup and logging an error.");
        lockInputStacks = cfg.getBoolean("Lock Crafting Input Stacks", "general", false, "If true, the stacks used as recipe inputs will be locked and throw an error if modified during parallel matching. Useful for debugging.");
        unsafeMode = cfg.getBoolean("Unsafe Mode", "general", false, "If true, FastSuite parallelize all recipes without validation. This can cause crashes if a recipe is not thread safe.");
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    public static void registerSafeRecipeClass(Class<?> clazz) {
        CachedRecipeList.parallelRecipeClassCache.put(clazz, true);
    }

    public static void registerSafeIngredientClass(Class<?> clazz) {
        CachedRecipeList.ingredientClassCache.put(clazz, true);
    }

    public void test(ServerStartedEvent e) {
        LOGGER.info("FastSuite Debug Recipe Counts:");
        for (RecipeType type : BuiltInRegistries.RECIPE_TYPE) {
            LOGGER.info("{}: {}", (Object)BuiltInRegistries.RECIPE_TYPE.getKey((Object)type), (Object)e.getServer().getRecipeManager().getAllRecipesFor(type).size());
        }
        LOGGER.info("Initiating FastSuite Tests...");
        AuxRecipeManager mgr = (AuxRecipeManager)e.getServer().getRecipeManager();
        TransientCraftingContainer inv = new TransientCraftingContainer((AbstractContainerMenu)new TestMenu(), 2, 2);
        ServerLevel world = e.getServer().getLevel(Level.OVERWORLD);
        inv.setItem(0, new ItemStack((ItemLike)Items.ACACIA_LOG));
        TransientCraftingContainer inv2 = new TransientCraftingContainer((AbstractContainerMenu)new TestMenu(), 2, 2);
        inv2.setItem(0, new ItemStack((ItemLike)Items.BIRCH_PLANKS));
        inv2.setItem(2, new ItemStack((ItemLike)Items.BIRCH_PLANKS));
        TransientCraftingContainer inv3 = new TransientCraftingContainer((AbstractContainerMenu)new TestMenu(), 2, 2);
        for (int i = 0; i < 4; ++i) {
            inv3.setItem(i, new ItemStack((ItemLike)Items.OAK_PLANKS));
        }
        TransientCraftingContainer inv4 = new TransientCraftingContainer((AbstractContainerMenu)new TestMenu(), 2, 2);
        inv4.setItem(0, new ItemStack((ItemLike)Items.SHULKER_BOX));
        inv4.setItem(3, new ItemStack((ItemLike)Items.BLACK_DYE));
        TransientCraftingContainer inv5 = new TransientCraftingContainer((AbstractContainerMenu)new TestMenu(), 3, 3);
        inv5.setItem(0, new ItemStack((ItemLike)Items.STICK));
        inv5.setItem(1, new ItemStack((ItemLike)Items.STICKY_PISTON));
        inv5.setItem(2, new ItemStack((ItemLike)Items.ACACIA_FENCE));
        inv5.setItem(3, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        inv5.setItem(4, new ItemStack((ItemLike)Items.APPLE));
        inv5.setItem(5, new ItemStack((ItemLike)Items.BEEHIVE));
        inv5.setItem(6, new ItemStack((ItemLike)Items.BEE_NEST));
        inv5.setItem(7, new ItemStack((ItemLike)Items.BLACK_DYE));
        inv5.setItem(8, new ItemStack((ItemLike)Items.SHULKER_BOX));
        CraftingContainer[] arr = new CraftingContainer[]{inv, inv2, inv3, inv4, inv5};
        String[] names = new String[]{"acacia planks", "sticks", "crafting table", "black shulker box", "failed match"};
        for (int testCase = 0; testCase < names.length; ++testCase) {
            this.testMulti(mgr, (Level)world, arr[testCase].asCraftInput(), names[testCase]);
            this.testSingle(mgr, (Level)world, arr[testCase].asCraftInput(), names[testCase]);
        }
    }

    private void testMulti(AuxRecipeManager mgr, Level level, CraftingInput input, String recipeName) {
        long deltaSum = 0L;
        int iterations = 10000;
        for (int i = 0; i < iterations; ++i) {
            long time = System.nanoTime();
            mgr.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, level);
            long time2 = System.nanoTime();
            deltaSum += time2 - time;
        }
        LOGGER.info("[Multithreaded Test] - Took an average of {} ns to find the recipe for {}", (Object)Float.valueOf((float)deltaSum / (float)iterations), (Object)recipeName);
    }

    private void testSingle(AuxRecipeManager mgr, Level level, CraftingInput input, String recipeName) {
        long deltaSum = 0L;
        int iterations = 10000;
        for (int i = 0; i < iterations; ++i) {
            long time = System.nanoTime();
            mgr.super_getRecipeFor(RecipeType.CRAFTING, input, level);
            long time2 = System.nanoTime();
            deltaSum += time2 - time;
        }
        LOGGER.info("[Singlethreaded Test] - Took an average of {} ns to find the recipe for {}", (Object)Float.valueOf((float)deltaSum / (float)iterations), (Object)recipeName);
    }

    private static class TestMenu
    extends AbstractContainerMenu {
        protected TestMenu() {
            super(null, -1);
        }

        public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
            return ItemStack.EMPTY;
        }

        public boolean stillValid(Player pPlayer) {
            return true;
        }
    }
}

