/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.goals;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;

public class CreeperMeleeAttackGoal
extends MeleeAttackGoal {
    private final BaseCreeper creeper;

    public CreeperMeleeAttackGoal(BaseCreeper creeper, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super((PathfinderMob)creeper, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.creeper = creeper;
    }

    protected void checkAndPerformAttack(@NotNull LivingEntity enemy) {
        if (this.mob.isWithinMeleeAttackRange(enemy) && this.isTimeToAttack()) {
            this.resetAttackCooldown();
            this.creeper.type.getHitSound(this.creeper).ifPresent(s -> this.creeper.level().playSound(null, (Entity)this.creeper, s, this.creeper.getSoundSource(), 0.5f, 1.0f));
            this.mob.doHurtTarget((Entity)enemy);
        } else if (this.mob.isWithinMeleeAttackRange(enemy)) {
            this.creeper.setAttacking(true);
        } else {
            this.resetAttackCooldown();
            this.creeper.setAttacking(false);
        }
    }

    protected int adjustedTickDelay(int p_186072_) {
        return super.adjustedTickDelay(p_186072_) + this.creeper.type.melee() - 4;
    }

    public void stop() {
        this.creeper.setAttacking(false);
        super.stop();
    }
}

