/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TinyCactusBlock
extends BushBlock
implements Equipable {
    private static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    private static final MapCodec<TinyCactusBlock> CODEC = MapCodec.unit(TinyCactusBlock::new);

    public TinyCactusBlock() {
        super(BlockBehaviour.Properties.of().strength(0.4f).sound(SoundType.WOOL).dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        Vec3 vec3 = state.getOffset(level, pos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.is(BlockTags.SAND) || state.is(Blocks.CACTUS) || state.is(BlockTags.TERRACOTTA) || state.is(BlockTags.DIRT);
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }
}

