/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dan200.computercraft.core.util.Nullability;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NBTUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NBTUtil.class);
    @VisibleForTesting
    static final BaseEncoding ENCODING = BaseEncoding.base16().lowerCase();

    private NBTUtil() {
    }

    @Nullable
    public static <T> T decodeFrom(Codec<T> codec, HolderLookup.Provider registries, CompoundTag tag, String key) {
        Tag childTag = tag.get(key);
        return childTag == null ? null : codec.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)childTag).resultOrPartial(e -> LOG.warn("Failed to parse NBT: {}", e)).orElse(null);
    }

    public static <T> void encodeTo(Codec<T> codec, HolderLookup.Provider registries, CompoundTag destination, String key, @Nullable T value) {
        if (value == null) {
            return;
        }
        codec.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), value).resultOrPartial(e -> LOG.warn("Failed to save NBT: {}", e)).ifPresent(x -> destination.put(key, x));
    }

    @Nullable
    private static Tag toNBTTag(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return ByteTag.valueOf((byte)((byte)((Boolean)object != false ? 1 : 0)));
        }
        if (object instanceof Number) {
            return DoubleTag.valueOf((double)((Number)object).doubleValue());
        }
        if (object instanceof String) {
            return StringTag.valueOf((String)object.toString());
        }
        if (object instanceof Map) {
            Map m = (Map)object;
            CompoundTag nbt = new CompoundTag();
            int i = 0;
            for (Map.Entry entry : m.entrySet()) {
                Tag key = NBTUtil.toNBTTag(entry.getKey());
                Tag value = NBTUtil.toNBTTag(entry.getKey());
                if (key == null || value == null) continue;
                nbt.put("k" + i, key);
                nbt.put("v" + i, value);
                ++i;
            }
            nbt.putInt("len", m.size());
            return nbt;
        }
        return null;
    }

    @Nullable
    public static CompoundTag encodeObjects(@Nullable Object[] objects) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("len", objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Tag child = NBTUtil.toNBTTag(objects[i]);
            if (child == null) continue;
            nbt.put(Integer.toString(i), child);
        }
        return nbt;
    }

    @Nullable
    private static Object fromNBTTag(@Nullable Tag tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.getId()) {
            case 1: {
                return ((ByteTag)tag).getAsByte() > 0;
            }
            case 6: {
                return ((DoubleTag)tag).getAsDouble();
            }
            default: {
                return tag.getAsString();
            }
            case 10: 
        }
        CompoundTag c = (CompoundTag)tag;
        int len = c.getInt("len");
        HashMap<Object, Object> map = new HashMap<Object, Object>(len);
        for (int i = 0; i < len; ++i) {
            Object key = NBTUtil.fromNBTTag(c.get("k" + i));
            Object value = NBTUtil.fromNBTTag(c.get("v" + i));
            if (key == null || value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    @Nullable
    public static Object toLua(@Nullable Tag tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.getId()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ((NumericTag)tag).getAsLong();
            }
            case 5: 
            case 6: {
                return ((NumericTag)tag).getAsDouble();
            }
            case 8: {
                return tag.getAsString();
            }
            case 10: {
                CompoundTag compound = (CompoundTag)tag;
                HashMap<String, Object> map = new HashMap<String, Object>(compound.size());
                for (String key : compound.getAllKeys()) {
                    Object value = NBTUtil.toLua(compound.get(key));
                    if (value == null) continue;
                    map.put(key, value);
                }
                return map;
            }
            case 9: {
                ListTag list = (ListTag)tag;
                ArrayList<Object> map = new ArrayList<Object>(list.size());
                for (Tag value : list) {
                    map.add(NBTUtil.toLua(value));
                }
                return map;
            }
            case 7: {
                byte[] array = ((ByteArrayTag)tag).getAsByteArray();
                ArrayList<Byte> map = new ArrayList<Byte>(array.length);
                for (byte b : array) {
                    map.add(b);
                }
                return map;
            }
            case 11: {
                int[] array = ((IntArrayTag)tag).getAsIntArray();
                ArrayList<Integer> map = new ArrayList<Integer>(array.length);
                for (int j : array) {
                    map.add(j);
                }
                return map;
            }
        }
        return null;
    }

    @Nullable
    public static Object[] decodeObjects(CompoundTag tag) {
        int len = tag.getInt("len");
        if (len <= 0) {
            return null;
        }
        Object[] objects = new Object[len];
        for (int i = 0; i < len; ++i) {
            String key = Integer.toString(i);
            if (!tag.contains(key)) continue;
            objects[i] = NBTUtil.fromNBTTag(tag.get(key));
        }
        return objects;
    }

    @Nullable
    public static String getNBTHash(@Nullable Tag tag) {
        if (tag == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DataOutputStream output = new DataOutputStream(new DigestOutputStream(digest));
            NBTUtil.writeNamedTag(output, "", tag);
            byte[] hash = digest.digest();
            return ENCODING.encode(hash);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOG.error("Cannot hash NBT", (Throwable)e);
            return null;
        }
    }

    private static void writeNamedTag(DataOutput output, String name, Tag tag) throws IOException {
        output.writeByte(tag.getId());
        if (tag.getId() == 0) {
            return;
        }
        output.writeUTF(name);
        NBTUtil.writeTag(output, tag);
    }

    private static void writeTag(DataOutput output, Tag tag) throws IOException {
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            Object[] keys = compound.getAllKeys().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                NBTUtil.writeNamedTag(output, (String)key, Nullability.assertNonNull(compound.get((String)key)));
            }
            output.writeByte(0);
        } else if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            output.writeByte(list.isEmpty() ? 0 : (int)list.get(0).getId());
            output.writeInt(list.size());
            for (Tag value : list) {
                NBTUtil.writeTag(output, value);
            }
        } else {
            tag.write(output);
        }
    }

    @VisibleForTesting
    static final class DigestOutputStream
    extends OutputStream {
        private final MessageDigest digest;

        DigestOutputStream(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.digest.update(b, off, len);
        }

        @Override
        public void write(int b) {
            this.digest.update((byte)b);
        }
    }
}

