/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.inventory;

import com.mojang.datafixers.util.Pair;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.impl.TurtleUpgrades;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class UpgradeSlot
extends Slot {
    public static final ResourceLocation LEFT_UPGRADE = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"gui/turtle_upgrade_left");
    public static final ResourceLocation RIGHT_UPGRADE = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"gui/turtle_upgrade_right");
    private final HolderLookup.Provider registries;
    private final TurtleSide side;

    public UpgradeSlot(Container container, HolderLookup.Provider registries, TurtleSide side, int slot, int xPos, int yPos) {
        super(container, slot, xPos, yPos);
        this.registries = registries;
        this.side = side;
    }

    public boolean mayPlace(ItemStack stack) {
        return TurtleUpgrades.instance().get(this.registries, stack) != null;
    }

    public int getMaxStackSize() {
        return 1;
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)(this.side == TurtleSide.LEFT ? LEFT_UPGRADE : RIGHT_UPGRADE));
    }
}

