/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.api.component.ComputerComponents;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.client.PocketComputerDeletedClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.pocket.core.PocketBrain;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.util.ComponentMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public final class PocketServerComputer
extends ServerComputer {
    private final PocketBrain brain;
    private int oldLightColour = -1;
    @Nullable
    private ComputerState oldComputerState;
    private Set<ServerPlayer> tracking = Set.of();

    PocketServerComputer(PocketBrain brain, PocketHolder holder, int computerID, @Nullable String label, ComputerFamily family) {
        super(holder.level(), holder.blockPos(), computerID, label, family, Config.pocketTermWidth, Config.pocketTermHeight, ComponentMap.builder().add(ComputerComponents.POCKET, brain).build());
        this.brain = brain;
    }

    public PocketBrain getBrain() {
        return this.brain;
    }

    @Override
    protected void tickServer() {
        List<ServerPlayer> added;
        super.tickServer();
        List newTracking = this.getLevel().getChunkSource().chunkMap.getPlayers(new ChunkPos(this.getPosition()), false);
        boolean trackingChanged = this.tracking.size() != newTracking.size() || !this.tracking.containsAll(newTracking);
        ComputerState state = this.getState();
        int light = this.brain.getLight();
        if (this.oldLightColour != light || this.oldComputerState != state) {
            this.oldComputerState = state;
            this.oldLightColour = light;
            ServerNetworking.sendToPlayers(new PocketComputerDataMessage(this, false), newTracking);
        } else if (trackingChanged && !(added = newTracking.stream().filter(x -> !this.tracking.contains(x)).toList()).isEmpty()) {
            ServerNetworking.sendToPlayers(new PocketComputerDataMessage(this, false), added);
        }
        if (trackingChanged) {
            this.tracking = Set.copyOf(newTracking);
        }
    }

    @Override
    protected void onTerminalChanged() {
        PocketHolder.PlayerHolder holder;
        super.onTerminalChanged();
        PocketHolder pocketHolder = this.brain.holder();
        if (pocketHolder instanceof PocketHolder.PlayerHolder && (holder = (PocketHolder.PlayerHolder)pocketHolder).isValid(this)) {
            ServerNetworking.sendToPlayer(new PocketComputerDataMessage(this, true), holder.entity());
        }
    }

    @Override
    protected void onRemoved() {
        super.onRemoved();
        ServerNetworking.sendToAllPlayers(new PocketComputerDeletedClientMessage(this.getInstanceUUID()), this.getLevel().getServer());
    }
}

