/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.phys.Vec3;

public final class PocketBrain
implements IPocketAccess {
    private final PocketServerComputer computer;
    private PocketHolder holder;
    private Vec3 position;
    private boolean dirty = false;
    @Nullable
    private UpgradeData<IPocketUpgrade> upgrade;
    private int colour = -1;
    private int lightColour = -1;

    public PocketBrain(PocketHolder holder, int computerID, @Nullable String label, ComputerFamily family, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        this.computer = new PocketServerComputer(this, holder, computerID, label, family);
        this.holder = holder;
        this.position = holder.pos();
        this.upgrade = upgrade;
        this.invalidatePeripheral();
    }

    public PocketServerComputer computer() {
        return this.computer;
    }

    PocketHolder holder() {
        return this.holder;
    }

    public void updateHolder(PocketHolder newHolder) {
        PocketHolder.PlayerHolder player;
        ServerPlayer oldPlayer;
        this.position = newHolder.pos();
        this.computer.setPosition(newHolder.level(), newHolder.blockPos());
        PocketHolder oldHolder = this.holder;
        if (this.holder.equals(newHolder)) {
            return;
        }
        this.holder = newHolder;
        if (oldHolder instanceof PocketHolder.PlayerHolder) {
            PocketHolder.PlayerHolder p = (PocketHolder.PlayerHolder)oldHolder;
            v0 = p.entity();
        } else {
            v0 = oldPlayer = null;
        }
        if (newHolder instanceof PocketHolder.PlayerHolder && (player = (PocketHolder.PlayerHolder)newHolder).entity() != oldPlayer) {
            ServerNetworking.sendToPlayer(new PocketComputerDataMessage(this.computer, true), player.entity());
        }
    }

    public boolean updateItem(ItemStack stack) {
        if (!this.dirty) {
            return false;
        }
        this.dirty = false;
        stack.set(DataComponents.DYED_COLOR, (Object)(this.colour == -1 ? null : new DyedItemColor(this.colour, false)));
        PocketComputerItem.setUpgrade(stack, this.upgrade);
        return true;
    }

    @Override
    public ServerLevel getLevel() {
        return this.computer.getLevel();
    }

    @Override
    public Vec3 getPosition() {
        return this.position;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Entity getEntity() {
        PocketHolder pocketHolder = this.holder;
        if (!(pocketHolder instanceof PocketHolder.EntityHolder)) return null;
        PocketHolder.EntityHolder entity = (PocketHolder.EntityHolder)pocketHolder;
        if (!this.holder.isValid(this.computer)) return null;
        Entity entity2 = entity.entity();
        return entity2;
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public void setColour(int colour) {
        if (this.colour == colour) {
            return;
        }
        this.dirty = true;
        this.colour = colour;
    }

    @Override
    public int getLight() {
        return this.lightColour;
    }

    @Override
    public void setLight(int colour) {
        if (colour < 0 || colour > 0xFFFFFF) {
            colour = -1;
        }
        this.lightColour = colour;
    }

    @Override
    public DataComponentPatch getUpgradeData() {
        UpgradeData<IPocketUpgrade> upgrade = this.upgrade;
        return upgrade == null ? DataComponentPatch.EMPTY : upgrade.data();
    }

    @Override
    public void setUpgradeData(DataComponentPatch data) {
        UpgradeData<IPocketUpgrade> upgrade = this.upgrade;
        if (upgrade == null) {
            return;
        }
        this.upgrade = UpgradeData.of(upgrade.holder(), data);
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : this.upgrade.upgrade().createPeripheral(this);
        this.computer.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Override
    @Nullable
    public UpgradeData<IPocketUpgrade> getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void setUpgrade(@Nullable UpgradeData<IPocketUpgrade> upgrade) {
        this.upgrade = upgrade;
        this.dirty = true;
        this.invalidatePeripheral();
    }
}

