/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import com.mojang.serialization.MapCodec;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.util.BlockCodecs;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class MonitorBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final MapCodec<MonitorBlock> CODEC = BlockCodecs.blockWithBlockEntityCodec(MonitorBlock::new, x -> x.type);
    public static final DirectionProperty ORIENTATION = DirectionProperty.create((String)"orientation", (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<MonitorEdgeState> STATE = EnumProperty.create((String)"state", MonitorEdgeState.class);
    private final RegistryEntry<? extends BlockEntityType<? extends MonitorBlockEntity>> type;

    public MonitorBlock(BlockBehaviour.Properties settings, RegistryEntry<? extends BlockEntityType<? extends MonitorBlockEntity>> type) {
        super(settings);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ORIENTATION, (Comparable)Direction.NORTH)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STATE, (Comparable)((Object)MonitorEdgeState.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ORIENTATION, FACING, STATE});
    }

    protected MapCodec<? extends MonitorBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        float pitch;
        float f = pitch = context.getPlayer() == null ? 0.0f : context.getPlayer().getXRot();
        Direction orientation = pitch > 66.5f ? Direction.UP : (pitch < -66.5f ? Direction.DOWN : Direction.NORTH);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)ORIENTATION, (Comparable)orientation);
    }

    protected final void onRemove(BlockState block, Level world, BlockPos pos, BlockState replace, boolean bool) {
        if (block.getBlock() == replace.getBlock()) {
            return;
        }
        BlockEntity tile = world.getBlockEntity(pos);
        super.onRemove(block, world, pos, replace, bool);
        if (tile instanceof MonitorBlockEntity) {
            MonitorBlockEntity generic = (MonitorBlockEntity)tile;
            generic.destroy();
        }
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof MonitorBlockEntity) {
            MonitorBlockEntity monitor = (MonitorBlockEntity)te;
            monitor.blockTick();
        }
    }

    protected final InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        MonitorBlockEntity monitor;
        BlockEntity blockEntity;
        if (player.isCrouching() || !((blockEntity = level.getBlockEntity(pos)) instanceof MonitorBlockEntity) || (monitor = (MonitorBlockEntity)blockEntity).getFront() != hit.getDirection()) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            monitor.monitorTouched((float)(hit.getLocation().x - (double)hit.getBlockPos().getX()), (float)(hit.getLocation().y - (double)hit.getBlockPos().getY()), (float)(hit.getLocation().z - (double)hit.getBlockPos().getZ()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        block2: {
            MonitorBlockEntity monitor;
            block4: {
                block3: {
                    super.setPlacedBy(world, pos, blockState, livingEntity, itemStack);
                    BlockEntity entity = world.getBlockEntity(pos);
                    if (!(entity instanceof MonitorBlockEntity)) break block2;
                    monitor = (MonitorBlockEntity)entity;
                    if (world.isClientSide) break block2;
                    if (livingEntity == null) break block3;
                    if (!(livingEntity instanceof ServerPlayer)) break block4;
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    if (!PlatformHelper.get().isFakePlayer(player)) break block4;
                }
                monitor.updateNeighborsDeferred();
                return;
            }
            monitor.expand();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)this.type.get()).create(blockPos, blockState);
    }
}

