/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import java.util.Collection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public final class ServerNetworking {
    private ServerNetworking() {
    }

    public static void sendToPlayer(NetworkMessage<ClientNetworkContext> message, ServerPlayer player) {
        player.connection.send(ServerNetworking.createPacket(message));
    }

    public static void sendToPlayers(NetworkMessage<ClientNetworkContext> message, Collection<ServerPlayer> players) {
        if (players.isEmpty()) {
            return;
        }
        Packet<ClientCommonPacketListener> packet = ServerNetworking.createPacket(message);
        for (ServerPlayer player : players) {
            player.connection.send(packet);
        }
    }

    public static void sendToAllPlayers(NetworkMessage<ClientNetworkContext> message, MinecraftServer server) {
        server.getPlayerList().broadcastAll(ServerNetworking.createPacket(message));
    }

    public static void sendToAllAround(NetworkMessage<ClientNetworkContext> message, ServerLevel level, Vec3 pos, float distance) {
        level.getServer().getPlayerList().broadcast(null, pos.x, pos.y, pos.z, (double)distance, level.dimension(), ServerNetworking.createPacket(message));
    }

    public static void sendToAllTracking(NetworkMessage<ClientNetworkContext> message, LevelChunk chunk) {
        Packet<ClientCommonPacketListener> packet = ServerNetworking.createPacket(message);
        for (ServerPlayer player : ((ServerChunkCache)chunk.getLevel().getChunkSource()).chunkMap.getPlayers(chunk.getPos(), false)) {
            player.connection.send(packet);
        }
    }

    private static Packet<ClientCommonPacketListener> createPacket(NetworkMessage<ClientNetworkContext> message) {
        return new ClientboundCustomPayloadPacket(message);
    }
}

