/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.component.AdminComputer;
import dan200.computercraft.api.component.ComputerComponents;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.arguments.ComputerArgumentType;
import dan200.computercraft.shared.command.arguments.RepeatArgumentType;
import dan200.computercraft.shared.command.arguments.TrackingFieldArgumentType;
import dan200.computercraft.shared.common.ClearColourRecipe;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.computer.apis.CommandAPI;
import dan200.computercraft.shared.computer.blocks.CommandComputerBlock;
import dan200.computercraft.shared.computer.blocks.ComputerBlock;
import dan200.computercraft.shared.computer.blocks.ComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.items.CommandComputerItem;
import dan200.computercraft.shared.computer.items.ComputerItem;
import dan200.computercraft.shared.computer.items.ServerComputerReference;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.details.BlockDetails;
import dan200.computercraft.shared.details.ItemDetails;
import dan200.computercraft.shared.integration.PermissionRegistry;
import dan200.computercraft.shared.lectern.CustomLecternBlock;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.media.PrintoutMenu;
import dan200.computercraft.shared.media.items.DiskItem;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.media.items.RecordMedia;
import dan200.computercraft.shared.media.items.TreasureDisk;
import dan200.computercraft.shared.media.items.TreasureDiskItem;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlockEntity;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveMenu;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockItem;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlock;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.printer.PrinterBlock;
import dan200.computercraft.shared.peripheral.printer.PrinterBlockEntity;
import dan200.computercraft.shared.peripheral.printer.PrinterMenu;
import dan200.computercraft.shared.peripheral.speaker.SpeakerBlock;
import dan200.computercraft.shared.peripheral.speaker.SpeakerBlockEntity;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RegistrationHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.pocket.peripherals.PocketModem;
import dan200.computercraft.shared.pocket.peripherals.PocketSpeaker;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.recipe.BasicRecipeSerialiser;
import dan200.computercraft.shared.recipe.CustomShapedRecipe;
import dan200.computercraft.shared.recipe.CustomShapelessRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapedRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapelessRecipe;
import dan200.computercraft.shared.recipe.TransformShapedRecipe;
import dan200.computercraft.shared.recipe.TransformShapelessRecipe;
import dan200.computercraft.shared.recipe.function.CopyComponents;
import dan200.computercraft.shared.recipe.function.RecipeFunction;
import dan200.computercraft.shared.turtle.FurnaceRefuelHandler;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.apis.TurtleAPI;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.core.TurtleAccessInternal;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.turtle.upgrades.TurtleCraftingTable;
import dan200.computercraft.shared.turtle.upgrades.TurtleModem;
import dan200.computercraft.shared.turtle.upgrades.TurtleSpeaker;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import dan200.computercraft.shared.util.ComponentMap;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class ModRegistry {
    private ModRegistry() {
    }

    public static void register() {
        Blocks.REGISTRY.register();
        BlockEntities.REGISTRY.register();
        DataComponents.REGISTRY.register();
        Items.REGISTRY.register();
        TurtleUpgradeTypes.REGISTRY.register();
        PocketUpgradeTypes.REGISTRY.register();
        Menus.REGISTRY.register();
        ArgumentTypes.REGISTRY.register();
        LootItemConditionTypes.REGISTRY.register();
        RecipeSerializers.REGISTRY.register();
        RecipeFunctions.REGISTRY.register();
        Permissions.REGISTRY.register();
        CreativeTabs.REGISTRY.register();
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerRefuelHandler(new FurnaceRefuelHandler());
        ComputerCraftAPI.registerMediaProvider(stack -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof IMedia) {
                IMedia media = (IMedia)patt0$temp;
                return media;
            }
            if (stack.has(net.minecraft.core.component.DataComponents.JUKEBOX_PLAYABLE)) {
                return RecordMedia.INSTANCE;
            }
            return null;
        });
        ComputerCraftAPI.registerAPIFactory(computer -> {
            ITurtleAccess turtle = computer.getComponent(ComputerComponents.TURTLE);
            MetricsObserver metrics = Objects.requireNonNull(computer.getComponent(ComponentMap.METRICS));
            return turtle == null ? null : new TurtleAPI(metrics, (TurtleAccessInternal)turtle);
        });
        ComputerCraftAPI.registerAPIFactory(computer -> {
            IPocketAccess pocket = computer.getComponent(ComputerComponents.POCKET);
            return pocket == null ? null : new PocketAPI(pocket);
        });
        ComputerCraftAPI.registerAPIFactory(computer -> {
            AdminComputer admin = computer.getComponent(ComputerComponents.ADMIN_COMPUTER);
            return admin == null ? null : new CommandAPI(computer, admin);
        });
        VanillaDetailRegistries.ITEM_STACK.addProvider(ItemDetails::fill);
        VanillaDetailRegistries.BLOCK_IN_WORLD.addProvider(BlockDetails::fill);
    }

    public static void registerMainThread() {
        CauldronInteraction.WATER.map().put((Item)Items.TURTLE_NORMAL.get(), TurtleItem.CAULDRON_INTERACTION);
        CauldronInteraction.WATER.map().put((Item)Items.TURTLE_ADVANCED.get(), TurtleItem.CAULDRON_INTERACTION);
    }

    private static void addTurtle(CreativeModeTab.Output out, TurtleItem turtle, HolderLookup.Provider registries) {
        out.accept(new ItemStack((ItemLike)turtle));
        registries.lookupOrThrow(ITurtleUpgrade.REGISTRY).listElements().filter(ModRegistry::isOurUpgrade).map(x -> DataComponentUtil.createStack((ItemLike)turtle, (DataComponentType)DataComponents.RIGHT_TURTLE_UPGRADE.get(), UpgradeData.ofDefault(x))).forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
    }

    private static void addPocket(CreativeModeTab.Output out, PocketComputerItem pocket, HolderLookup.Provider registries) {
        out.accept(new ItemStack((ItemLike)pocket));
        registries.lookupOrThrow(IPocketUpgrade.REGISTRY).listElements().filter(ModRegistry::isOurUpgrade).map(x -> DataComponentUtil.createStack((ItemLike)pocket, (DataComponentType)DataComponents.POCKET_UPGRADE.get(), UpgradeData.ofDefault(x))).forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0));
    }

    private static boolean isOurUpgrade(Holder.Reference<? extends UpgradeBase> upgrade) {
        String namespace = upgrade.key().location().getNamespace();
        return namespace.equals("minecraft") || namespace.equals("computercraft");
    }

    public static final class Blocks {
        static final RegistrationHelper<Block> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.BLOCK);
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_NORMAL = REGISTRY.register("computer_normal", () -> new ComputerBlock(Blocks.computerProperties().mapColor(MapColor.STONE), BlockEntities.COMPUTER_NORMAL));
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_ADVANCED = REGISTRY.register("computer_advanced", () -> new ComputerBlock(Blocks.computerProperties().mapColor(MapColor.GOLD), BlockEntities.COMPUTER_ADVANCED));
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_COMMAND = REGISTRY.register("computer_command", () -> new CommandComputerBlock(Blocks.computerProperties().strength(-1.0f, 6000000.0f), BlockEntities.COMPUTER_COMMAND));
        public static final RegistryEntry<TurtleBlock> TURTLE_NORMAL = REGISTRY.register("turtle_normal", () -> new TurtleBlock(Blocks.turtleProperties().mapColor(MapColor.STONE), BlockEntities.TURTLE_NORMAL));
        public static final RegistryEntry<TurtleBlock> TURTLE_ADVANCED = REGISTRY.register("turtle_advanced", () -> new TurtleBlock(Blocks.turtleProperties().mapColor(MapColor.GOLD).explosionResistance(2000.0f), BlockEntities.TURTLE_ADVANCED));
        public static final RegistryEntry<SpeakerBlock> SPEAKER = REGISTRY.register("speaker", () -> new SpeakerBlock(Blocks.properties().mapColor(MapColor.STONE)));
        public static final RegistryEntry<DiskDriveBlock> DISK_DRIVE = REGISTRY.register("disk_drive", () -> new DiskDriveBlock(Blocks.properties().mapColor(MapColor.STONE)));
        public static final RegistryEntry<PrinterBlock> PRINTER = REGISTRY.register("printer", () -> new PrinterBlock(Blocks.properties().mapColor(MapColor.STONE)));
        public static final RegistryEntry<MonitorBlock> MONITOR_NORMAL = REGISTRY.register("monitor_normal", () -> new MonitorBlock(Blocks.properties().mapColor(MapColor.STONE), BlockEntities.MONITOR_NORMAL));
        public static final RegistryEntry<MonitorBlock> MONITOR_ADVANCED = REGISTRY.register("monitor_advanced", () -> new MonitorBlock(Blocks.properties().mapColor(MapColor.GOLD), BlockEntities.MONITOR_ADVANCED));
        public static final RegistryEntry<WirelessModemBlock> WIRELESS_MODEM_NORMAL = REGISTRY.register("wireless_modem_normal", () -> new WirelessModemBlock(Blocks.properties().mapColor(MapColor.STONE), BlockEntities.WIRELESS_MODEM_NORMAL));
        public static final RegistryEntry<WirelessModemBlock> WIRELESS_MODEM_ADVANCED = REGISTRY.register("wireless_modem_advanced", () -> new WirelessModemBlock(Blocks.properties().mapColor(MapColor.GOLD), BlockEntities.WIRELESS_MODEM_ADVANCED));
        public static final RegistryEntry<WiredModemFullBlock> WIRED_MODEM_FULL = REGISTRY.register("wired_modem_full", () -> new WiredModemFullBlock(Blocks.modemProperties().mapColor(MapColor.STONE)));
        public static final RegistryEntry<CableBlock> CABLE = REGISTRY.register("cable", () -> new CableBlock(Blocks.modemProperties().mapColor(MapColor.STONE)));
        public static final RegistryEntry<CustomLecternBlock> LECTERN = REGISTRY.register("lectern", () -> new CustomLecternBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava()));

        private static BlockBehaviour.Properties properties() {
            return BlockBehaviour.Properties.of().strength(2.0f);
        }

        private static BlockBehaviour.Properties computerProperties() {
            return Blocks.properties().isRedstoneConductor((block, level, blockPos) -> false);
        }

        private static BlockBehaviour.Properties turtleProperties() {
            return BlockBehaviour.Properties.of().strength(2.5f);
        }

        private static BlockBehaviour.Properties modemProperties() {
            return BlockBehaviour.Properties.of().strength(1.5f);
        }
    }

    public static class BlockEntities {
        static final RegistrationHelper<BlockEntityType<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.BLOCK_ENTITY_TYPE);
        public static final RegistryEntry<BlockEntityType<MonitorBlockEntity>> MONITOR_NORMAL = BlockEntities.ofBlock(Blocks.MONITOR_NORMAL, (p, s) -> new MonitorBlockEntity((BlockEntityType<? extends MonitorBlockEntity>)((BlockEntityType)MONITOR_NORMAL.get()), p, s, false));
        public static final RegistryEntry<BlockEntityType<MonitorBlockEntity>> MONITOR_ADVANCED = BlockEntities.ofBlock(Blocks.MONITOR_ADVANCED, (p, s) -> new MonitorBlockEntity((BlockEntityType<? extends MonitorBlockEntity>)((BlockEntityType)MONITOR_ADVANCED.get()), p, s, true));
        public static final RegistryEntry<BlockEntityType<ComputerBlockEntity>> COMPUTER_NORMAL = BlockEntities.ofBlock(Blocks.COMPUTER_NORMAL, (p, s) -> new ComputerBlockEntity((BlockEntityType<? extends ComputerBlockEntity>)((BlockEntityType)COMPUTER_NORMAL.get()), p, s, ComputerFamily.NORMAL));
        public static final RegistryEntry<BlockEntityType<ComputerBlockEntity>> COMPUTER_ADVANCED = BlockEntities.ofBlock(Blocks.COMPUTER_ADVANCED, (p, s) -> new ComputerBlockEntity((BlockEntityType<? extends ComputerBlockEntity>)((BlockEntityType)COMPUTER_ADVANCED.get()), p, s, ComputerFamily.ADVANCED));
        public static final RegistryEntry<BlockEntityType<ComputerBlockEntity>> COMPUTER_COMMAND = BlockEntities.ofBlock(Blocks.COMPUTER_COMMAND, (p, s) -> new ComputerBlockEntity((BlockEntityType<? extends ComputerBlockEntity>)((BlockEntityType)COMPUTER_COMMAND.get()), p, s, ComputerFamily.COMMAND));
        public static final RegistryEntry<BlockEntityType<TurtleBlockEntity>> TURTLE_NORMAL = BlockEntities.ofBlock(Blocks.TURTLE_NORMAL, (p, s) -> new TurtleBlockEntity((BlockEntityType<? extends TurtleBlockEntity>)((BlockEntityType)TURTLE_NORMAL.get()), p, s, () -> Config.turtleFuelLimit, ComputerFamily.NORMAL));
        public static final RegistryEntry<BlockEntityType<TurtleBlockEntity>> TURTLE_ADVANCED = BlockEntities.ofBlock(Blocks.TURTLE_ADVANCED, (p, s) -> new TurtleBlockEntity((BlockEntityType<? extends TurtleBlockEntity>)((BlockEntityType)TURTLE_ADVANCED.get()), p, s, () -> Config.advancedTurtleFuelLimit, ComputerFamily.ADVANCED));
        public static final RegistryEntry<BlockEntityType<SpeakerBlockEntity>> SPEAKER = BlockEntities.ofBlock(Blocks.SPEAKER, (p, s) -> new SpeakerBlockEntity((BlockEntityType<SpeakerBlockEntity>)((BlockEntityType)SPEAKER.get()), p, s));
        public static final RegistryEntry<BlockEntityType<DiskDriveBlockEntity>> DISK_DRIVE = BlockEntities.ofBlock(Blocks.DISK_DRIVE, (p, s) -> new DiskDriveBlockEntity((BlockEntityType<DiskDriveBlockEntity>)((BlockEntityType)DISK_DRIVE.get()), p, s));
        public static final RegistryEntry<BlockEntityType<PrinterBlockEntity>> PRINTER = BlockEntities.ofBlock(Blocks.PRINTER, (p, s) -> new PrinterBlockEntity((BlockEntityType<PrinterBlockEntity>)((BlockEntityType)PRINTER.get()), p, s));
        public static final RegistryEntry<BlockEntityType<WiredModemFullBlockEntity>> WIRED_MODEM_FULL = BlockEntities.ofBlock(Blocks.WIRED_MODEM_FULL, (p, s) -> new WiredModemFullBlockEntity((BlockEntityType<WiredModemFullBlockEntity>)((BlockEntityType)WIRED_MODEM_FULL.get()), p, s));
        public static final RegistryEntry<BlockEntityType<CableBlockEntity>> CABLE = BlockEntities.ofBlock(Blocks.CABLE, (p, s) -> new CableBlockEntity((BlockEntityType<? extends CableBlockEntity>)((BlockEntityType)CABLE.get()), p, s));
        public static final RegistryEntry<BlockEntityType<WirelessModemBlockEntity>> WIRELESS_MODEM_NORMAL = BlockEntities.ofBlock(Blocks.WIRELESS_MODEM_NORMAL, (p, s) -> new WirelessModemBlockEntity((BlockEntityType<? extends WirelessModemBlockEntity>)((BlockEntityType)WIRELESS_MODEM_NORMAL.get()), p, s, false));
        public static final RegistryEntry<BlockEntityType<WirelessModemBlockEntity>> WIRELESS_MODEM_ADVANCED = BlockEntities.ofBlock(Blocks.WIRELESS_MODEM_ADVANCED, (p, s) -> new WirelessModemBlockEntity((BlockEntityType<? extends WirelessModemBlockEntity>)((BlockEntityType)WIRELESS_MODEM_ADVANCED.get()), p, s, true));
        public static final RegistryEntry<BlockEntityType<CustomLecternBlockEntity>> LECTERN = BlockEntities.ofBlock(Blocks.LECTERN, CustomLecternBlockEntity::new);

        private static <T extends BlockEntity> RegistryEntry<BlockEntityType<T>> ofBlock(RegistryEntry<? extends Block> block, BlockEntityType.BlockEntitySupplier<T> factory) {
            return REGISTRY.register(block.id().getPath(), () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])new Block[]{(Block)block.get()}).build(null));
        }
    }

    public static final class DataComponents {
        static final RegistrationHelper<DataComponentType<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.DATA_COMPONENT_TYPE);
        public static final RegistryEntry<DataComponentType<NonNegativeId>> COMPUTER_ID = DataComponents.register("computer_id", b -> b.persistent(NonNegativeId.CODEC).networkSynchronized(NonNegativeId.STREAM_CODEC));
        public static final RegistryEntry<DataComponentType<UpgradeData<ITurtleUpgrade>>> LEFT_TURTLE_UPGRADE = DataComponents.register("left_turtle_upgrade", b -> b.persistent(TurtleUpgrades.instance().upgradeDataCodec()).networkSynchronized(TurtleUpgrades.instance().upgradeDataStreamCodec()));
        public static final RegistryEntry<DataComponentType<UpgradeData<ITurtleUpgrade>>> RIGHT_TURTLE_UPGRADE = DataComponents.register("right_turtle_upgrade", b -> b.persistent(TurtleUpgrades.instance().upgradeDataCodec()).networkSynchronized(TurtleUpgrades.instance().upgradeDataStreamCodec()));
        public static final RegistryEntry<DataComponentType<Integer>> FUEL = DataComponents.register("fuel", b -> b.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
        public static final RegistryEntry<DataComponentType<Holder<TurtleOverlay>>> OVERLAY = DataComponents.register("overlay", b -> b.persistent(TurtleOverlay.CODEC).networkSynchronized(TurtleOverlay.STREAM_CODEC));
        public static final RegistryEntry<DataComponentType<UpgradeData<IPocketUpgrade>>> POCKET_UPGRADE = DataComponents.register("pocket_upgrade", b -> b.persistent(PocketUpgrades.instance().upgradeDataCodec()).networkSynchronized(PocketUpgrades.instance().upgradeDataStreamCodec()));
        public static final RegistryEntry<DataComponentType<ServerComputerReference>> COMPUTER = DataComponents.register("computer", b -> b.persistent(ServerComputerReference.CODEC).networkSynchronized(ServerComputerReference.STREAM_CODEC));
        public static final RegistryEntry<DataComponentType<Boolean>> ON = DataComponents.register("on", b -> b.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
        public static final RegistryEntry<DataComponentType<TreasureDisk>> TREASURE_DISK = DataComponents.register("treasure_disk", b -> b.persistent(TreasureDisk.CODEC).networkSynchronized(TreasureDisk.STREAM_CODEC));
        public static final RegistryEntry<DataComponentType<NonNegativeId>> DISK_ID = DataComponents.register("disk_id", b -> b.persistent(NonNegativeId.CODEC).networkSynchronized(NonNegativeId.STREAM_CODEC));
        public static final RegistryEntry<DataComponentType<PrintoutData>> PRINTOUT = DataComponents.register("printout", b -> b.persistent(PrintoutData.CODEC).networkSynchronized(PrintoutData.STREAM_CODEC));

        private static <T> RegistryEntry<DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> unaryOperator) {
            return REGISTRY.register(name, () -> ((DataComponentType.Builder)unaryOperator.apply(DataComponentType.builder())).build());
        }
    }

    public static final class Items {
        static final RegistrationHelper<Item> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.ITEM);
        public static final RegistryEntry<ComputerItem> COMPUTER_NORMAL = Items.ofBlock(Blocks.COMPUTER_NORMAL, ComputerItem::new);
        public static final RegistryEntry<ComputerItem> COMPUTER_ADVANCED = Items.ofBlock(Blocks.COMPUTER_ADVANCED, ComputerItem::new);
        public static final RegistryEntry<ComputerItem> COMPUTER_COMMAND = Items.ofBlock(Blocks.COMPUTER_COMMAND, CommandComputerItem::new);
        public static final RegistryEntry<PocketComputerItem> POCKET_COMPUTER_NORMAL = REGISTRY.register("pocket_computer_normal", () -> new PocketComputerItem(Items.properties().stacksTo(1), ComputerFamily.NORMAL));
        public static final RegistryEntry<PocketComputerItem> POCKET_COMPUTER_ADVANCED = REGISTRY.register("pocket_computer_advanced", () -> new PocketComputerItem(Items.properties().stacksTo(1), ComputerFamily.ADVANCED));
        public static final RegistryEntry<TurtleItem> TURTLE_NORMAL = Items.ofBlock(Blocks.TURTLE_NORMAL, TurtleItem::new);
        public static final RegistryEntry<TurtleItem> TURTLE_ADVANCED = Items.ofBlock(Blocks.TURTLE_ADVANCED, TurtleItem::new);
        public static final RegistryEntry<DiskItem> DISK = REGISTRY.register("disk", () -> new DiskItem(Items.properties().stacksTo(1)));
        public static final RegistryEntry<TreasureDiskItem> TREASURE_DISK = REGISTRY.register("treasure_disk", () -> new TreasureDiskItem(Items.properties().stacksTo(1)));
        public static final RegistryEntry<PrintoutItem> PRINTED_PAGE = REGISTRY.register("printed_page", () -> new PrintoutItem(Items.printoutProperties(), PrintoutItem.Type.PAGE));
        public static final RegistryEntry<PrintoutItem> PRINTED_PAGES = REGISTRY.register("printed_pages", () -> new PrintoutItem(Items.printoutProperties(), PrintoutItem.Type.PAGES));
        public static final RegistryEntry<PrintoutItem> PRINTED_BOOK = REGISTRY.register("printed_book", () -> new PrintoutItem(Items.printoutProperties(), PrintoutItem.Type.BOOK));
        public static final RegistryEntry<BlockItem> SPEAKER = Items.ofBlock(Blocks.SPEAKER, BlockItem::new);
        public static final RegistryEntry<BlockItem> DISK_DRIVE = Items.ofBlock(Blocks.DISK_DRIVE, BlockItem::new);
        public static final RegistryEntry<BlockItem> PRINTER = Items.ofBlock(Blocks.PRINTER, BlockItem::new);
        public static final RegistryEntry<BlockItem> MONITOR_NORMAL = Items.ofBlock(Blocks.MONITOR_NORMAL, BlockItem::new);
        public static final RegistryEntry<BlockItem> MONITOR_ADVANCED = Items.ofBlock(Blocks.MONITOR_ADVANCED, BlockItem::new);
        public static final RegistryEntry<BlockItem> WIRELESS_MODEM_NORMAL = Items.ofBlock(Blocks.WIRELESS_MODEM_NORMAL, BlockItem::new);
        public static final RegistryEntry<BlockItem> WIRELESS_MODEM_ADVANCED = Items.ofBlock(Blocks.WIRELESS_MODEM_ADVANCED, BlockItem::new);
        public static final RegistryEntry<BlockItem> WIRED_MODEM_FULL = Items.ofBlock(Blocks.WIRED_MODEM_FULL, BlockItem::new);
        public static final RegistryEntry<CableBlockItem.Cable> CABLE = REGISTRY.register("cable", () -> new CableBlockItem.Cable((CableBlock)((Object)((Object)Blocks.CABLE.get())), Items.properties()));
        public static final RegistryEntry<CableBlockItem.WiredModem> WIRED_MODEM = REGISTRY.register("wired_modem", () -> new CableBlockItem.WiredModem((CableBlock)((Object)((Object)Blocks.CABLE.get())), Items.properties()));

        private static Item.Properties properties() {
            return new Item.Properties();
        }

        private static <B extends Block, I extends Item> RegistryEntry<I> ofBlock(RegistryEntry<B> parent, BiFunction<B, Item.Properties, I> supplier) {
            return REGISTRY.register(parent.id().getPath(), () -> (Item)supplier.apply((Block)parent.get(), Items.properties()));
        }

        private static Item.Properties printoutProperties() {
            return Items.properties().stacksTo(1).component((DataComponentType)DataComponents.PRINTOUT.get(), (Object)PrintoutData.EMPTY);
        }
    }

    public static class TurtleUpgradeTypes {
        static final RegistrationHelper<UpgradeType<? extends ITurtleUpgrade>> REGISTRY = PlatformHelper.get().createRegistrationHelper(ITurtleUpgrade.typeRegistry());
        public static final RegistryEntry<UpgradeType<TurtleSpeaker>> SPEAKER = REGISTRY.register("speaker", () -> UpgradeType.simpleWithCustomItem(TurtleSpeaker::new));
        public static final RegistryEntry<UpgradeType<TurtleCraftingTable>> WORKBENCH = REGISTRY.register("workbench", () -> UpgradeType.simpleWithCustomItem(TurtleCraftingTable::new));
        public static final RegistryEntry<UpgradeType<TurtleModem>> WIRELESS_MODEM = REGISTRY.register("wireless_modem", () -> UpgradeType.create(TurtleModem.CODEC));
        public static final RegistryEntry<UpgradeType<TurtleTool>> TOOL = REGISTRY.register("tool", () -> UpgradeType.create(TurtleTool.CODEC));
    }

    public static class PocketUpgradeTypes {
        static final RegistrationHelper<UpgradeType<? extends IPocketUpgrade>> REGISTRY = PlatformHelper.get().createRegistrationHelper(IPocketUpgrade.typeRegistry());
        public static final RegistryEntry<UpgradeType<PocketSpeaker>> SPEAKER = REGISTRY.register("speaker", () -> UpgradeType.simpleWithCustomItem(PocketSpeaker::new));
        public static final RegistryEntry<UpgradeType<PocketModem>> WIRELESS_MODEM = REGISTRY.register("wireless_modem", () -> UpgradeType.create(PocketModem.CODEC));
    }

    public static class Menus {
        static final RegistrationHelper<MenuType<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.MENU);
        public static final RegistryEntry<MenuType<ComputerMenuWithoutInventory>> COMPUTER = REGISTRY.register("computer", () -> ContainerData.toType(ComputerContainerData.STREAM_CODEC, (id, inv, data) -> new ComputerMenuWithoutInventory((MenuType<? extends AbstractComputerMenu>)((MenuType)COMPUTER.get()), id, inv, (ComputerContainerData)data)));
        public static final RegistryEntry<MenuType<ComputerMenuWithoutInventory>> POCKET_COMPUTER_NO_TERM = REGISTRY.register("pocket_computer_no_term", () -> ContainerData.toType(ComputerContainerData.STREAM_CODEC, (id, inv, data) -> new ComputerMenuWithoutInventory((MenuType<? extends AbstractComputerMenu>)((MenuType)POCKET_COMPUTER_NO_TERM.get()), id, inv, (ComputerContainerData)data)));
        public static final RegistryEntry<MenuType<TurtleMenu>> TURTLE = REGISTRY.register("turtle", () -> ContainerData.toType(ComputerContainerData.STREAM_CODEC, TurtleMenu::ofMenuData));
        public static final RegistryEntry<MenuType<DiskDriveMenu>> DISK_DRIVE = REGISTRY.register("disk_drive", () -> new MenuType(DiskDriveMenu::new, FeatureFlags.VANILLA_SET));
        public static final RegistryEntry<MenuType<PrinterMenu>> PRINTER = REGISTRY.register("printer", () -> new MenuType(PrinterMenu::new, FeatureFlags.VANILLA_SET));
        public static final RegistryEntry<MenuType<PrintoutMenu>> PRINTOUT = REGISTRY.register("printout", () -> new MenuType((i, c) -> PrintoutMenu.createRemote(i), FeatureFlags.VANILLA_SET));
    }

    static class ArgumentTypes {
        static final RegistrationHelper<ArgumentTypeInfo<?, ?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.COMMAND_ARGUMENT_TYPE);

        ArgumentTypes() {
        }

        private static <T extends ArgumentType<?>> void registerUnsafe(String name, Class<T> type, ArgumentTypeInfo<?, ?> serializer) {
            REGISTRY.register(name, () -> PlatformHelper.get().registerArgumentTypeInfo(type, serializer));
        }

        private static <T extends ArgumentType<?>> void register(String name, Class<T> type, ArgumentTypeInfo<T, ?> serializer) {
            REGISTRY.register(name, () -> PlatformHelper.get().registerArgumentTypeInfo(type, serializer));
        }

        private static <T extends ArgumentType<?>> void register(String name, Class<T> type, T instance) {
            ArgumentTypes.register(name, type, SingletonArgumentInfo.contextFree(() -> instance));
        }

        static {
            ArgumentTypes.register("tracking_field", TrackingFieldArgumentType.class, TrackingFieldArgumentType.metric());
            ArgumentTypes.register("computer", ComputerArgumentType.class, ComputerArgumentType.get());
            ArgumentTypes.registerUnsafe("repeat", RepeatArgumentType.class, new RepeatArgumentType.Info());
        }
    }

    public static class LootItemConditionTypes {
        static final RegistrationHelper<LootItemConditionType> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.LOOT_CONDITION_TYPE);
        public static final RegistryEntry<LootItemConditionType> BLOCK_NAMED = REGISTRY.register("block_named", () -> new LootItemConditionType(MapCodec.unit((Object)BlockNamedEntityLootCondition.INSTANCE)));
        public static final RegistryEntry<LootItemConditionType> PLAYER_CREATIVE = REGISTRY.register("player_creative", () -> new LootItemConditionType(MapCodec.unit((Object)PlayerCreativeLootCondition.INSTANCE)));
        public static final RegistryEntry<LootItemConditionType> HAS_ID = REGISTRY.register("has_id", () -> new LootItemConditionType(MapCodec.unit((Object)HasComputerIdLootCondition.INSTANCE)));
    }

    public static class RecipeSerializers {
        static final RegistrationHelper<RecipeSerializer<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.RECIPE_SERIALIZER);
        public static final RegistryEntry<RecipeSerializer<ImpostorShapedRecipe>> IMPOSTOR_SHAPED = REGISTRY.register("impostor_shaped", () -> CustomShapedRecipe.serialiser(ImpostorShapedRecipe::new));
        public static final RegistryEntry<RecipeSerializer<ImpostorShapelessRecipe>> IMPOSTOR_SHAPELESS = REGISTRY.register("impostor_shapeless", () -> CustomShapelessRecipe.serialiser(ImpostorShapelessRecipe::new));
        public static final RegistryEntry<RecipeSerializer<TransformShapedRecipe>> TRANSFORM_SHAPED = RecipeSerializers.register("transform_shaped", TransformShapedRecipe.CODEC, TransformShapedRecipe.STREAM_CODEC);
        public static final RegistryEntry<RecipeSerializer<TransformShapelessRecipe>> TRANSFORM_SHAPELESS = RecipeSerializers.register("transform_shapeless", TransformShapelessRecipe.CODEC, TransformShapelessRecipe.STREAM_CODEC);
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<ColourableRecipe>> DYEABLE_ITEM = RecipeSerializers.simple("colour", ColourableRecipe::new);
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<ClearColourRecipe>> DYEABLE_ITEM_CLEAR = RecipeSerializers.simple("clear_colour", ClearColourRecipe::new);
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<TurtleUpgradeRecipe>> TURTLE_UPGRADE = RecipeSerializers.simple("turtle_upgrade", TurtleUpgradeRecipe::new);
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<PocketComputerUpgradeRecipe>> POCKET_COMPUTER_UPGRADE = RecipeSerializers.simple("pocket_computer_upgrade", PocketComputerUpgradeRecipe::new);
        public static final RegistryEntry<RecipeSerializer<PrintoutRecipe>> PRINTOUT = RecipeSerializers.register("printout", PrintoutRecipe.CODEC, PrintoutRecipe.STREAM_CODEC);
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<DiskRecipe>> DISK = RecipeSerializers.simple("disk", DiskRecipe::new);

        private static <T extends CustomRecipe> RegistryEntry<SimpleCraftingRecipeSerializer<T>> simple(String name, SimpleCraftingRecipeSerializer.Factory<T> factory) {
            return REGISTRY.register(name, () -> new SimpleCraftingRecipeSerializer(factory));
        }

        private static <T extends Recipe<?>> RegistryEntry<RecipeSerializer<T>> register(String name, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
            return REGISTRY.register(name, () -> new BasicRecipeSerialiser(codec, streamCodec));
        }
    }

    public static class RecipeFunctions {
        static final RegistrationHelper<RecipeFunction.Type<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(RecipeFunction.REGISTRY);
        public static final RegistryEntry<RecipeFunction.Type<CopyComponents>> COPY_COMPONENTS = RecipeFunctions.register("copy_components", CopyComponents.CODEC, CopyComponents.STREAM_CODEC);

        private static <T extends RecipeFunction> RegistryEntry<RecipeFunction.Type<T>> register(String name, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
            return REGISTRY.register(name, () -> new RecipeFunction.Type(codec, streamCodec));
        }
    }

    public static class Permissions {
        static final PermissionRegistry REGISTRY = PermissionRegistry.create();
        public static final Predicate<CommandSourceStack> PERMISSION_DUMP = REGISTRY.registerCommand("dump", UserLevel.OWNER_OP);
        public static final Predicate<CommandSourceStack> PERMISSION_SHUTDOWN = REGISTRY.registerCommand("shutdown", UserLevel.OWNER_OP);
        public static final Predicate<CommandSourceStack> PERMISSION_TURN_ON = REGISTRY.registerCommand("turn_on", UserLevel.OWNER_OP);
        public static final Predicate<CommandSourceStack> PERMISSION_TP = REGISTRY.registerCommand("tp", UserLevel.OP);
        public static final Predicate<CommandSourceStack> PERMISSION_TRACK = REGISTRY.registerCommand("track", UserLevel.OWNER_OP);
        public static final Predicate<CommandSourceStack> PERMISSION_QUEUE = REGISTRY.registerCommand("queue", UserLevel.ANYONE);
        public static final Predicate<CommandSourceStack> PERMISSION_VIEW = REGISTRY.registerCommand("view", UserLevel.OP);
    }

    static class CreativeTabs {
        static final RegistrationHelper<CreativeModeTab> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.CREATIVE_MODE_TAB);
        private static final RegistryEntry<CreativeModeTab> TAB = REGISTRY.register("tab", () -> PlatformHelper.get().newCreativeModeTab().icon(() -> new ItemStack((ItemLike)Items.COMPUTER_NORMAL.get())).title((Component)Component.translatable((String)"itemGroup.computercraft")).displayItems((context, out) -> {
            out.accept(new ItemStack((ItemLike)Items.COMPUTER_NORMAL.get()));
            out.accept(new ItemStack((ItemLike)Items.COMPUTER_ADVANCED.get()));
            if (context.hasPermissions()) {
                out.accept(new ItemStack((ItemLike)Items.COMPUTER_COMMAND.get()));
            }
            ModRegistry.addTurtle(out, (TurtleItem)Items.TURTLE_NORMAL.get(), context.holders());
            ModRegistry.addTurtle(out, (TurtleItem)Items.TURTLE_ADVANCED.get(), context.holders());
            ModRegistry.addPocket(out, (PocketComputerItem)Items.POCKET_COMPUTER_NORMAL.get(), context.holders());
            ModRegistry.addPocket(out, (PocketComputerItem)Items.POCKET_COMPUTER_ADVANCED.get(), context.holders());
            out.accept((ItemLike)Items.WIRELESS_MODEM_NORMAL.get());
            out.accept((ItemLike)Items.WIRELESS_MODEM_ADVANCED.get());
            out.accept((ItemLike)Items.CABLE.get());
            out.accept((ItemLike)Items.WIRED_MODEM.get());
            out.accept((ItemLike)Items.WIRED_MODEM_FULL.get());
            out.accept((ItemLike)Items.MONITOR_NORMAL.get());
            out.accept((ItemLike)Items.MONITOR_ADVANCED.get());
            out.accept((ItemLike)Items.SPEAKER.get());
            out.accept((ItemLike)Items.PRINTER.get());
            out.accept((ItemLike)Items.PRINTED_PAGE.get());
            out.accept((ItemLike)Items.PRINTED_PAGES.get());
            out.accept((ItemLike)Items.PRINTED_BOOK.get());
            out.accept((ItemLike)Items.DISK_DRIVE.get());
            for (int colour = 0; colour < 16; ++colour) {
                out.accept(DataComponentUtil.createStack((ItemLike)Items.DISK.get(), net.minecraft.core.component.DataComponents.DYED_COLOR, new DyedItemColor(Colour.VALUES[colour].getHex(), false)));
            }
        }).build());

        CreativeTabs() {
        }
    }
}

