/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data.recipe;

import dan200.computercraft.data.recipe.AbstractRecipeBuilder;
import dan200.computercraft.shared.recipe.RecipeProperties;
import dan200.computercraft.shared.recipe.ShapelessRecipeSpec;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class ShapelessSpecBuilder
extends AbstractRecipeBuilder<ShapelessSpecBuilder, ShapelessRecipeSpec> {
    private final NonNullList<Ingredient> ingredients = NonNullList.create();

    private ShapelessSpecBuilder(RecipeCategory category, ItemStack result) {
        super(category, result);
    }

    public static ShapelessSpecBuilder shapeless(RecipeCategory category, ItemStack result) {
        return new ShapelessSpecBuilder(category, result);
    }

    public static ShapelessSpecBuilder shapeless(RecipeCategory category, ItemLike result) {
        return new ShapelessSpecBuilder(category, new ItemStack(result));
    }

    public ShapelessSpecBuilder requires(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public ShapelessSpecBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public ShapelessSpecBuilder requires(ItemLike item) {
        return this.requires(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack(item)}));
    }

    public ShapelessSpecBuilder requires(ItemLike item, int count) {
        return this.requires(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack(item)}), count);
    }

    public ShapelessSpecBuilder requires(TagKey<Item> item) {
        return this.requires(Ingredient.of(item));
    }

    @Override
    protected ShapelessRecipeSpec build(RecipeProperties properties) {
        return new ShapelessRecipeSpec(properties, this.ingredients, this.result);
    }

    public AbstractRecipeBuilder.FinishedRecipe build() {
        return this.build(ShapelessRecipeSpec::create);
    }
}

