/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.util.Holiday;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class TurtleBlockEntityRenderer
implements BlockEntityRenderer<TurtleBlockEntity> {
    public static final ResourceLocation COLOUR_TURTLE_MODEL = ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"block/turtle_colour");
    private final BlockEntityRenderDispatcher renderer;
    private final Font font;

    public TurtleBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.getBlockEntityRenderDispatcher();
        this.font = context.getFont();
    }

    public void render(TurtleBlockEntity turtle, float partialTicks, PoseStack transform, MultiBufferSource buffers, int lightmapCoord, int overlayLight) {
        boolean showChristmas;
        transform.pushPose();
        Vec3 offset = turtle.getRenderOffset(partialTicks);
        transform.translate(offset.x, offset.y, offset.z);
        String label = turtle.getLabel();
        HitResult hit = this.renderer.cameraHitResult;
        if (label != null && hit != null && hit.getType() == HitResult.Type.BLOCK && turtle.getBlockPos().equals((Object)((BlockHitResult)hit).getBlockPos())) {
            Minecraft mc = Minecraft.getInstance();
            Font font = this.font;
            transform.pushPose();
            transform.translate(0.5, 1.2, 0.5);
            transform.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
            transform.scale(0.025f, -0.025f, 0.025f);
            Matrix4f matrix = transform.last().pose();
            int opacity = (int)(mc.options.getBackgroundOpacity(0.25f) * 255.0f) << 24;
            float width = (float)(-font.width(label)) / 2.0f;
            font.drawInBatch(label, width, 0.0f, 0x20FFFFFF, false, matrix, buffers, Font.DisplayMode.SEE_THROUGH, opacity, lightmapCoord);
            font.drawInBatch(label, width, 0.0f, -1, false, matrix, buffers, Font.DisplayMode.NORMAL, 0, lightmapCoord);
            transform.popPose();
        }
        transform.translate(0.5f, 0.5f, 0.5f);
        float yaw = turtle.getRenderYaw(partialTicks);
        transform.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        if (label != null && (label.equals("Dinnerbone") || label.equals("Grumm"))) {
            transform.scale(1.0f, -1.0f, 1.0f);
        }
        transform.translate(-0.5f, -0.5f, -0.5f);
        int colour = turtle.getColour();
        TurtleOverlay overlay = turtle.getOverlay();
        if (colour == -1) {
            ItemModelShaper modelManager = Minecraft.getInstance().getItemRenderer().getItemModelShaper();
            BakedModel model = modelManager.getItemModel(turtle.getBlockState().getBlock().asItem());
            if (model == null) {
                model = modelManager.getModelManager().getMissingModel();
            }
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, model, null);
        } else {
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, COLOUR_TURTLE_MODEL, new int[]{FastColor.ARGB32.opaque((int)colour)});
        }
        if (overlay != null) {
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, overlay.model(), null);
        }
        if (showChristmas = TurtleOverlay.showElfOverlay(overlay, Holiday.getCurrent() == Holiday.CHRISTMAS)) {
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, TurtleOverlay.ELF_MODEL, null);
        }
        this.renderUpgrade(transform, buffers, lightmapCoord, overlayLight, turtle, TurtleSide.LEFT, partialTicks);
        this.renderUpgrade(transform, buffers, lightmapCoord, overlayLight, turtle, TurtleSide.RIGHT, partialTicks);
        transform.popPose();
    }

    private void renderUpgrade(PoseStack transform, MultiBufferSource buffers, int lightmapCoord, int overlayLight, TurtleBlockEntity turtle, TurtleSide side, float f) {
        ITurtleUpgrade upgrade = turtle.getUpgrade(side);
        if (upgrade == null) {
            return;
        }
        transform.pushPose();
        float toolAngle = turtle.getToolRenderAngle(side, f);
        transform.translate(0.0f, 0.5f, 0.5f);
        transform.mulPose(Axis.XN.rotationDegrees(toolAngle));
        transform.translate(0.0f, -0.5f, -0.5f);
        TransformedModel model = TurtleUpgradeModellers.getModel(upgrade, turtle.getAccess(), side);
        TurtleBlockEntityRenderer.applyTransformation(transform, model.matrix());
        this.renderModel(transform, buffers, lightmapCoord, overlayLight, model.model(), null);
        transform.popPose();
    }

    private void renderModel(PoseStack transform, MultiBufferSource buffers, int lightmapCoord, int overlayLight, ResourceLocation modelLocation, @Nullable int[] tints) {
        ModelManager modelManager = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getModelManager();
        this.renderModel(transform, buffers, lightmapCoord, overlayLight, ClientPlatformHelper.get().getModel(modelManager, modelLocation), tints);
    }

    private void renderModel(PoseStack transform, MultiBufferSource renderer, int lightmapCoord, int overlayLight, BakedModel model, @Nullable int[] tints) {
        ClientPlatformHelper.get().renderBakedModel(transform, renderer, model, lightmapCoord, overlayLight, tints);
    }

    private static void applyTransformation(PoseStack stack, Transformation transformation) {
        Vector3f trans = transformation.getTranslation();
        stack.translate(trans.x(), trans.y(), trans.z());
        stack.mulPose(transformation.getLeftRotation());
        Vector3f scale = transformation.getScale();
        stack.scale(scale.x(), scale.y(), scale.z());
        stack.mulPose(transformation.getRightRotation());
    }
}

