/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.integration.emi;

import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.integration.RecipeModHelpers;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiStack;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;

@EmiEntrypoint
public class EMIComputerCraft
implements EmiPlugin {
    private static final Comparison turtleComparison = EMIComputerCraft.compareStacks((left, right) -> TurtleItem.getUpgrade(left, TurtleSide.LEFT) == TurtleItem.getUpgrade(right, TurtleSide.LEFT) && TurtleItem.getUpgrade(left, TurtleSide.RIGHT) == TurtleItem.getUpgrade(right, TurtleSide.RIGHT));
    private static final Comparison pocketComparison = EMIComputerCraft.compareStacks((left, right) -> PocketComputerItem.getUpgrade(left) == PocketComputerItem.getUpgrade(right));

    public void register(EmiRegistry registry) {
        registry.setDefaultComparison(ModRegistry.Items.TURTLE_NORMAL.get(), turtleComparison);
        registry.setDefaultComparison(ModRegistry.Items.TURTLE_ADVANCED.get(), turtleComparison);
        registry.setDefaultComparison(ModRegistry.Items.POCKET_COMPUTER_NORMAL.get(), pocketComparison);
        registry.setDefaultComparison(ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get(), pocketComparison);
        for (ItemStack stack : RecipeModHelpers.getExtraStacks((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())) {
            registry.addEmiStack(EmiStack.of((ItemStack)stack));
        }
    }

    private static Comparison compareStacks(BiPredicate<ItemStack, ItemStack> test) {
        return Comparison.of((left, right) -> {
            ItemStack leftStack = left.getItemStack();
            ItemStack rightStack = right.getItemStack();
            return leftStack.getItem() == rightStack.getItem() && test.test(leftStack, rightStack);
        });
    }
}

