/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.gui.ClientInputHandler;
import dan200.computercraft.client.gui.widgets.TerminalWidget;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class NoTermComputerScreen<T extends AbstractComputerMenu>
extends Screen
implements MenuAccess<T> {
    private final T menu;
    private final Terminal terminalData;
    @Nullable
    private TerminalWidget terminal;

    public NoTermComputerScreen(T menu, Inventory player, Component title) {
        super(title);
        this.menu = menu;
        this.terminalData = ((AbstractComputerMenu)menu).getTerminal();
    }

    public T getMenu() {
        return this.menu;
    }

    protected void init() {
        this.minecraft().mouseHandler.grabMouse();
        this.minecraft().screen = this;
        KeyMapping.releaseAll();
        super.init();
        this.terminal = (TerminalWidget)this.addWidget((GuiEventListener)new TerminalWidget(this.terminalData, new ClientInputHandler((AbstractContainerMenu)this.menu), 0, 0));
        this.terminal.visible = false;
        this.terminal.active = false;
        this.setFocused((GuiEventListener)this.terminal);
    }

    public final void tick() {
        super.tick();
        Nullability.assertNonNull(this.terminal).update();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        Objects.requireNonNull(this.minecraft().player).getInventory().swapPaint(scrollY);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void onClose() {
        Objects.requireNonNull(this.minecraft().player).closeContainer();
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public final boolean keyPressed(int key, int scancode, int modifiers) {
        if (key == 258 && this.getFocused() != null && this.getFocused() == this.terminal) {
            return this.getFocused().keyPressed(key, scancode, modifiers);
        }
        return super.keyPressed(key, scancode, modifiers);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        Font font = this.minecraft().font;
        List lines = font.split((FormattedText)Component.translatable((String)"gui.computercraft.pocket_computer_overlay"), (int)((double)this.width * 0.8));
        int y = 10;
        for (FormattedCharSequence line : lines) {
            graphics.drawString(font, line, this.width / 2 - font.width(line) / 2, y, 0xFFFFFF, true);
            y += 9;
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    private Minecraft minecraft() {
        return Nullability.assertNonNull(this.minecraft);
    }
}

