/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.lua.ObjectLuaTable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public interface IArguments {
    public int count();

    @Nullable
    public Object get(int var1) throws LuaException;

    public String getType(int var1);

    public IArguments drop(int var1);

    default public Object[] getAll() throws LuaException {
        Object[] result = new Object[this.count()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    default public double getDouble(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Number)) {
            throw LuaValues.badArgumentOf(this, index, "number");
        }
        Number number = (Number)value;
        return number.doubleValue();
    }

    default public int getInt(int index) throws LuaException {
        return (int)this.getLong(index);
    }

    default public long getLong(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Number)) {
            throw LuaValues.badArgumentOf(this, index, "number");
        }
        Number number = (Number)value;
        return LuaValues.checkFiniteNum(index, number).longValue();
    }

    default public double getFiniteDouble(int index) throws LuaException {
        return LuaValues.checkFinite(index, this.getDouble(index));
    }

    default public boolean getBoolean(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Boolean)) {
            throw LuaValues.badArgumentOf(this, index, "boolean");
        }
        Boolean bool = (Boolean)value;
        return bool;
    }

    default public String getString(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof String)) {
            throw LuaValues.badArgumentOf(this, index, "string");
        }
        String string = (String)value;
        return string;
    }

    default public String getStringCoerced(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return "nil";
        }
        if (value instanceof Boolean || value instanceof String) {
            return value.toString();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            double asDouble = number.doubleValue();
            int asInt = (int)asDouble;
            return (double)asInt == asDouble ? Integer.toString(asInt) : Double.toString(asDouble);
        }
        return String.format("%s: %08x", this.getType(index), value.hashCode());
    }

    default public ByteBuffer getBytes(int index) throws LuaException {
        return LuaValues.encode(this.getString(index));
    }

    default public ByteBuffer getBytesCoerced(int index) throws LuaException {
        return LuaValues.encode(this.getStringCoerced(index));
    }

    default public <T extends Enum<T>> T getEnum(int index, Class<T> klass) throws LuaException {
        return LuaValues.checkEnum(index, klass, this.getString(index));
    }

    default public Map<?, ?> getTable(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Map)) {
            throw LuaValues.badArgumentOf(this, index, "table");
        }
        return (Map)value;
    }

    default public LuaTable<?, ?> getTableUnsafe(int index) throws LuaException {
        return new ObjectLuaTable(this.getTable(index));
    }

    default public Optional<Double> optDouble(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Number)) {
            throw LuaValues.badArgumentOf(this, index, "number");
        }
        Number number = (Number)value;
        return Optional.of(number.doubleValue());
    }

    default public Optional<Integer> optInt(int index) throws LuaException {
        return this.optLong(index).map(Long::intValue);
    }

    default public Optional<Long> optLong(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Number)) {
            throw LuaValues.badArgumentOf(this, index, "number");
        }
        Number number = (Number)value;
        return Optional.of(LuaValues.checkFiniteNum(index, number).longValue());
    }

    default public Optional<Double> optFiniteDouble(int index) throws LuaException {
        Optional<Double> value = this.optDouble(index);
        if (value.isPresent()) {
            LuaValues.checkFiniteNum(index, value.get());
        }
        return value;
    }

    default public Optional<Boolean> optBoolean(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Boolean)) {
            throw LuaValues.badArgumentOf(this, index, "boolean");
        }
        Boolean bool = (Boolean)value;
        return Optional.of(bool);
    }

    default public Optional<String> optString(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof String)) {
            throw LuaValues.badArgumentOf(this, index, "string");
        }
        String string = (String)value;
        return Optional.of(string);
    }

    default public Optional<ByteBuffer> optBytes(int index) throws LuaException {
        return this.optString(index).map(LuaValues::encode);
    }

    default public <T extends Enum<T>> Optional<T> optEnum(int index, Class<T> klass) throws LuaException {
        Optional<String> str = this.optString(index);
        return str.isPresent() ? Optional.of(LuaValues.checkEnum(index, klass, str.get())) : Optional.empty();
    }

    default public Optional<Map<?, ?>> optTable(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Map)) {
            throw LuaValues.badArgumentOf(this, index, "map");
        }
        return Optional.of((Map)value);
    }

    default public Optional<LuaTable<?, ?>> optTableUnsafe(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Map)) {
            throw LuaValues.badArgumentOf(this, index, "map");
        }
        return Optional.of(new ObjectLuaTable((Map)value));
    }

    default public double optDouble(int index, double def) throws LuaException {
        return this.optDouble(index).orElse(def);
    }

    default public int optInt(int index, int def) throws LuaException {
        return this.optInt(index).orElse(def);
    }

    default public long optLong(int index, long def) throws LuaException {
        return this.optLong(index).orElse(def);
    }

    default public double optFiniteDouble(int index, double def) throws LuaException {
        return this.optFiniteDouble(index).orElse(def);
    }

    default public boolean optBoolean(int index, boolean def) throws LuaException {
        return this.optBoolean(index).orElse(def);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    default public String optString(int index, @Nullable String def) throws LuaException {
        return this.optString(index).orElse(def);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    default public Map<?, ?> optTable(int index, @Nullable Map<Object, Object> def) throws LuaException {
        return this.optTable(index).orElse(def);
    }

    default public void escapes() throws LuaException {
    }
}

