/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.util;

import com.google.common.base.Equivalence;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Streams;
import invtweaks.InvTweaksMod;
import invtweaks.config.Category;
import invtweaks.config.ContOverride;
import invtweaks.config.InvTweaksConfig;
import invtweaks.config.Ruleset;
import invtweaks.util.Utils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class Sorting {
    public static void executeSort(Player player, boolean isPlayerSort, String screenClass) {
        if (player != null && InvTweaksConfig.isDebugEnabled()) {
            InvTweaksMod.LOGGER.debug("screen: " + screenClass);
        }
        if (isPlayerSort) {
            Map<String, Category> cats = InvTweaksConfig.getPlayerCats(player);
            Ruleset rules = InvTweaksConfig.getPlayerRules(player);
            IntList lockedSlots = Optional.ofNullable(rules.catToInventorySlots("/LOCKED")).map(IntArrayList::new).orElseGet(IntArrayList::new);
            lockedSlots.addAll(Optional.ofNullable(rules.catToInventorySlots("/FROZEN")).orElse((IntList)IntLists.EMPTY_LIST));
            lockedSlots.sort(null);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Sorting.playerSortServer(serverPlayer, cats, rules, lockedSlots);
            } else {
                Sorting.playerSortClient(player, cats, rules, lockedSlots);
            }
        } else {
            ContOverride override;
            boolean isSortDisabled;
            AbstractContainerMenu cont = player.containerMenu;
            if (cont != player.inventoryMenu && !(isSortDisabled = Optional.ofNullable(override = InvTweaksConfig.getPlayerContOverride(player, screenClass, cont.getClass().getName())).filter(ContOverride::isSortDisabled).isPresent())) {
                List validSlots = (override != null && override.getSortRange() != null ? override.getSortRange().intStream().filter(Objects::nonNull).filter(idx -> 0 <= idx && idx < cont.slots.size()).mapToObj(arg_0 -> ((NonNullList)cont.slots).get(arg_0)) : cont.slots.stream()).filter(slot -> (slot instanceof SlotItemHandler || slot.container.getContainerSize() > 0) && !(slot.container instanceof Inventory)).filter(slot -> slot.mayPickup(player) && (slot.mayPlace(slot.getItem()) || !slot.hasItem())).collect(Collectors.toCollection(ArrayList::new));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Sorting.inventorySortServer(serverPlayer, validSlots);
                } else {
                    Sorting.inventorySortClient(player, validSlots);
                }
            }
        }
    }

    public static void playerSortClient(Player player, Map<String, Category> cats, Ruleset rules, IntList lockedSlots) {
        Inventory inv = player.getInventory();
        MultiPlayerGameMode pc = Minecraft.getInstance().gameMode;
        Int2ObjectMap indexToSlot = (Int2ObjectMap)player.containerMenu.slots.stream().filter(slot -> slot.container instanceof Inventory).filter(slot -> 0 <= slot.getSlotIndex() && slot.getSlotIndex() < 36).collect(Collectors.toMap(Slot::getSlotIndex, Function.identity(), (u, v) -> u, Int2ObjectOpenHashMap::new));
        IntList stackIdxs = (IntList)IntStream.range(0, inv.items.size()).filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).filter(idx -> !((ItemStack)inv.items.get(idx)).isEmpty()).collect(IntArrayList::new, IntList::add, IntList::addAll);
        Map<Equivalence.Wrapper<ItemStack>, Set<Slot>> gatheredSlots = Utils.gatheredSlots(() -> stackIdxs.stream().mapToInt(v -> v).mapToObj(arg_0 -> ((Int2ObjectMap)indexToSlot).get(arg_0)).filter(Slot::hasItem).iterator());
        ArrayList<Equivalence.Wrapper<ItemStack>> stackWs = new ArrayList<Equivalence.Wrapper<ItemStack>>(gatheredSlots.keySet());
        stackWs.sort(Comparator.comparing(Equivalence.Wrapper::get, Utils.FALLBACK_COMPARATOR));
        for (Map.Entry<String, Category> ent : cats.entrySet()) {
            IntList specificRules = rules.catToInventorySlots(ent.getKey());
            if (specificRules == null) {
                specificRules = IntLists.EMPTY_LIST;
            }
            specificRules = (IntList)specificRules.stream().filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).mapToInt(v -> v).collect(IntArrayList::new, IntList::add, IntList::addAll);
            List specificRulesSlots = specificRules.stream().map(idx -> (Slot)indexToSlot.get(idx.intValue())).collect(Collectors.toCollection(ArrayList::new));
            ListIterator<Slot> toIt = specificRulesSlots.listIterator();
            Client.processCategoryClient(player, pc, gatheredSlots, stackWs, ent.getValue(), toIt);
        }
        List fallbackList = Stream.concat(Streams.stream(Optional.ofNullable(rules.catToInventorySlots("/OTHER"))).flatMap(Collection::stream), rules.fallbackInventoryRules().stream()).mapToInt(v -> v).filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).distinct().mapToObj(arg_0 -> ((Int2ObjectMap)indexToSlot).get(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        Client.processCategoryClient(player, pc, gatheredSlots, stackWs, null, fallbackList.listIterator());
    }

    public static void playerSortServer(ServerPlayer player, Map<String, Category> cats, Ruleset rules, IntList lockedSlots) {
        Inventory inv = player.getInventory();
        List<ItemStack> stacks = Utils.condensed(() -> IntStream.range(0, inv.items.size()).filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).mapToObj(arg_0 -> ((NonNullList)inv.items).get(arg_0)).filter(st -> !st.isEmpty()).iterator());
        stacks.sort(Utils.FALLBACK_COMPARATOR);
        stacks = new LinkedList<ItemStack>(stacks);
        for (int i = 0; i < inv.items.size(); ++i) {
            if (Collections.binarySearch(lockedSlots, i) >= 0) continue;
            inv.items.set(i, (Object)ItemStack.EMPTY);
        }
        for (Map.Entry<String, Category> ent : cats.entrySet()) {
            IntList specificRules = rules.catToInventorySlots(ent.getKey());
            if (specificRules == null) {
                specificRules = IntLists.EMPTY_LIST;
            }
            specificRules = (IntList)specificRules.stream().filter(idx -> Collections.binarySearch(lockedSlots, idx) < 0).mapToInt(v -> v).collect(IntArrayList::new, IntList::add, IntList::addAll);
            ArrayList<ItemStack> curStacks = new ArrayList<ItemStack>();
            Iterator<ItemStack> it = stacks.iterator();
            while (it.hasNext() && curStacks.size() < specificRules.size()) {
                ItemStack st = it.next();
                if (ent.getValue().checkStack(st) < 0) continue;
                curStacks.add(st);
                it.remove();
            }
            curStacks.sort(Comparator.comparingInt(s -> ((Category)cats.get(ent.getKey())).checkStack((ItemStack)s)));
            Streams.zip((Stream)specificRules.stream(), curStacks.stream(), Pair::of).forEach(pr -> inv.items.set(((Integer)pr.getKey()).intValue(), (Object)((ItemStack)pr.getValue())));
        }
        PrimitiveIterator.OfInt fallbackIt = Stream.concat(Optional.ofNullable(rules.catToInventorySlots("/OTHER")).stream().flatMap(Collection::stream), rules.fallbackInventoryRules().stream()).mapToInt(v -> v).iterator();
        while (fallbackIt.hasNext()) {
            int idx2 = fallbackIt.nextInt();
            if (Collections.binarySearch(lockedSlots, idx2) >= 0) continue;
            if (stacks.isEmpty()) break;
            if (!((ItemStack)inv.items.get(idx2)).isEmpty()) continue;
            inv.items.set(idx2, (Object)stacks.remove(0));
        }
    }

    public static void inventorySortClient(Player player, List<Slot> validSlots) {
        MultiPlayerGameMode pc = Minecraft.getInstance().gameMode;
        Map<Equivalence.Wrapper<ItemStack>, Set<Slot>> gatheredSlots = Utils.gatheredSlots(() -> validSlots.stream().filter(Slot::hasItem).iterator());
        ArrayList<Equivalence.Wrapper<ItemStack>> stackWs = new ArrayList<Equivalence.Wrapper<ItemStack>>(gatheredSlots.keySet());
        stackWs.sort(Comparator.comparing(Equivalence.Wrapper::get, Utils.FALLBACK_COMPARATOR));
        ListIterator<Slot> toIt = validSlots.listIterator();
        for (Equivalence.Wrapper wrapper : stackWs) {
            HashBiMap displaced = HashBiMap.create();
            Client.clientPushToSlots(player, pc, gatheredSlots.get(wrapper).iterator(), toIt, (BiMap<Slot, Slot>)displaced);
            for (Map.Entry displacedPair : displaced.entrySet()) {
                Set<Slot> toModify = gatheredSlots.get(Utils.STACKABLE.wrap((Object)((Slot)displacedPair.getValue()).getItem()));
                toModify.remove(displacedPair.getKey());
                toModify.add((Slot)displacedPair.getValue());
            }
        }
    }

    public static void inventorySortServer(ServerPlayer serverPlayer, List<Slot> validSlots) {
        Slot cur;
        if (!validSlots.iterator().hasNext()) {
            return;
        }
        List<ItemStack> stacks = Utils.condensed(() -> validSlots.stream().map(Slot::getItem).filter(st -> !st.isEmpty()).iterator());
        stacks.sort(Utils.FALLBACK_COMPARATOR);
        Iterator<Slot> slotIt = validSlots.iterator();
        for (ItemStack stack : stacks) {
            cur = null;
            while (slotIt.hasNext() && !(cur = slotIt.next()).mayPlace(stack)) {
            }
            if (cur != null && cur.mayPlace(stack)) continue;
            return;
        }
        validSlots.forEach(slot -> slot.set(ItemStack.EMPTY));
        slotIt = validSlots.iterator();
        for (ItemStack stack : stacks) {
            cur = null;
            while (slotIt.hasNext() && !(cur = slotIt.next()).mayPlace(stack)) {
            }
            assert (cur != null);
            cur.set(stack);
        }
    }

    static class Client {
        private Client() {
        }

        static void processCategoryClient(Player player, MultiPlayerGameMode pc, Map<Equivalence.Wrapper<ItemStack>, Set<Slot>> gatheredSlots, List<Equivalence.Wrapper<ItemStack>> stackWs, Category cat, ListIterator<Slot> toIt) {
            ArrayList<Equivalence.Wrapper<ItemStack>> subStackWs = cat == null ? new ArrayList<Equivalence.Wrapper<ItemStack>>(stackWs) : (List)stackWs.stream().filter(stackW -> cat.checkStack((ItemStack)stackW.get()) >= 0).sorted(Comparator.comparingInt(stackW -> cat.checkStack((ItemStack)stackW.get()))).collect(Collectors.toCollection(ArrayList::new));
            for (Equivalence.Wrapper wrapper : subStackWs) {
                if (cat != null && cat.checkStack((ItemStack)wrapper.get()) < 0) continue;
                HashBiMap displaced = HashBiMap.create();
                ListIterator fromIt = (ListIterator)gatheredSlots.get(wrapper).iterator();
                boolean fullInserted = Client.clientPushToSlots(player, pc, fromIt, toIt, (BiMap<Slot, Slot>)displaced);
                for (Map.Entry displacedPair : displaced.entrySet()) {
                    Equivalence.Wrapper displacedW = Utils.STACKABLE.wrap((Object)((Slot)displacedPair.getValue()).getItem());
                    Set<Slot> toModify = gatheredSlots.get(displacedW);
                    toModify.remove(displacedPair.getKey());
                    toModify.add((Slot)displacedPair.getValue());
                }
            }
            stackWs.removeIf(sw -> ((Set)gatheredSlots.get(sw)).isEmpty());
            gatheredSlots.values().removeIf(Set::isEmpty);
        }

        static boolean clientPushToSlots(Player player, MultiPlayerGameMode playerController, Iterator<Slot> OriginIter, ListIterator<Slot> destinationIter, BiMap<Slot, Slot> displaced) {
            if (!destinationIter.hasNext()) {
                return true;
            }
            boolean completedCurrentItemSwap = true;
            while (OriginIter.hasNext()) {
                completedCurrentItemSwap = false;
                Slot originSlot = OriginIter.next();
                playerController.handleInventoryMouseClick(player.containerMenu.containerId, originSlot.index, 0, ClickType.PICKUP, player);
                Slot destinationSlot = null;
                while (destinationIter.hasNext()) {
                    if (destinationIter.hasPrevious() && ((destinationSlot = destinationIter.previous()).getItem().getCount() == Math.min(destinationSlot.getMaxStackSize(), destinationSlot.getItem().getMaxStackSize()) || !Utils.STACKABLE.equivalent((Object)destinationSlot.getItem(), (Object)player.containerMenu.getCarried()))) {
                        destinationIter.next();
                    }
                    destinationSlot = destinationIter.next();
                    playerController.handleInventoryMouseClick(player.containerMenu.containerId, destinationSlot.index, 0, ClickType.PICKUP, player);
                    if (player.containerMenu.getCarried().isEmpty()) {
                        completedCurrentItemSwap = true;
                        break;
                    }
                    if (Utils.STACKABLE.equivalent((Object)destinationSlot.getItem(), (Object)player.containerMenu.getCarried())) continue;
                    playerController.handleInventoryMouseClick(player.containerMenu.containerId, originSlot.index, 0, ClickType.PICKUP, player);
                    if (!originSlot.hasItem() || ItemStack.isSameItemSameComponents((ItemStack)originSlot.getItem(), (ItemStack)destinationSlot.getItem())) continue;
                    completedCurrentItemSwap = true;
                    displaced.put((Object)destinationSlot, (Object)originSlot);
                    break;
                }
                if (destinationIter.hasNext() || !Optional.ofNullable(destinationSlot).filter(s -> s.getItem().getCount() >= Math.min(s.getMaxStackSize(), s.getItem().getMaxStackSize())).isPresent()) continue;
                break;
            }
            return completedCurrentItemSwap;
        }
    }
}

