/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.network;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import invtweaks.config.InvTweaksConfig;
import invtweaks.config.Ruleset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public class PacketUpdateConfig
implements CustomPacketPayload,
IPayloadHandler<PacketUpdateConfig> {
    public static final CustomPacketPayload.Type<PacketUpdateConfig> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"invtweaks", (String)"packet_update_config"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateConfig> CODEC = new StreamCodec<RegistryFriendlyByteBuf, PacketUpdateConfig>(){

        public PacketUpdateConfig decode(RegistryFriendlyByteBuf buff) {
            return new PacketUpdateConfig(buff);
        }

        public void encode(RegistryFriendlyByteBuf buffer, PacketUpdateConfig packetUpdateConfig) {
            buffer.writeVarInt(packetUpdateConfig.cats.size());
            for (UnmodifiableConfig subCfg : packetUpdateConfig.cats) {
                buffer.writeUtf((String)subCfg.getOrElse("name", (Object)""));
                List spec = (List)subCfg.getOrElse("spec", Collections.emptyList());
                buffer.writeVarInt(spec.size());
                for (String subSpec : spec) {
                    buffer.writeUtf(subSpec);
                }
            }
            buffer.writeVarInt(packetUpdateConfig.rules.size());
            for (String subRule : packetUpdateConfig.rules) {
                buffer.writeUtf(subRule);
            }
            buffer.writeVarInt(packetUpdateConfig.contOverrides.size());
            for (UnmodifiableConfig contOverride : packetUpdateConfig.contOverrides) {
                buffer.writeUtf((String)contOverride.getOrElse("containerClass", (Object)""));
                int x = contOverride.getIntOrElse("x", -1418392593);
                int y = contOverride.getIntOrElse("y", -1418392593);
                buffer.writeInt(x).writeInt(y);
                buffer.writeUtf((String)contOverride.getOrElse("sortRange", (Object)"default"));
            }
            buffer.writeBoolean(packetUpdateConfig.autoRefill);
        }
    };
    private final List<UnmodifiableConfig> cats;
    private final List<String> rules;
    private final List<UnmodifiableConfig> contOverrides;
    private final boolean autoRefill;

    public PacketUpdateConfig() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false);
    }

    public PacketUpdateConfig(List<UnmodifiableConfig> cats, List<String> rules, List<UnmodifiableConfig> contOverrides, boolean autoRefill) {
        this.cats = cats;
        this.rules = rules;
        this.contOverrides = contOverrides;
        this.autoRefill = autoRefill;
    }

    public PacketUpdateConfig(RegistryFriendlyByteBuf buf) {
        this.cats = new ArrayList<UnmodifiableConfig>();
        int catsSize = buf.readVarInt();
        for (int i = 0; i < catsSize; ++i) {
            CommentedConfig subCfg = CommentedConfig.inMemory();
            subCfg.set("name", (Object)buf.readUtf(Short.MAX_VALUE));
            ArrayList<String> spec = new ArrayList<String>();
            int specSize = buf.readVarInt();
            for (int j = 0; j < specSize; ++j) {
                spec.add(buf.readUtf(Short.MAX_VALUE));
            }
            subCfg.set("spec", spec);
            this.cats.add((UnmodifiableConfig)subCfg);
        }
        this.rules = new ArrayList<String>();
        int rulesSize = buf.readVarInt();
        for (int i = 0; i < rulesSize; ++i) {
            this.rules.add(buf.readUtf(Short.MAX_VALUE));
        }
        this.contOverrides = new ArrayList<UnmodifiableConfig>();
        int contOverridesSize = buf.readVarInt();
        for (int i = 0; i < contOverridesSize; ++i) {
            CommentedConfig contOverride = CommentedConfig.inMemory();
            contOverride.set("containerClass", (Object)buf.readUtf(Short.MAX_VALUE));
            contOverride.set("x", (Object)buf.readInt());
            contOverride.set("y", (Object)buf.readInt());
            contOverride.set("sortRange", (Object)buf.readUtf(Short.MAX_VALUE));
            this.contOverrides.add((UnmodifiableConfig)contOverride);
        }
        this.autoRefill = buf.readBoolean();
    }

    public void handle(PacketUpdateConfig packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            InvTweaksConfig.setPlayerCats(ctx.player(), InvTweaksConfig.cfgToCompiledCats(packet.cats));
            InvTweaksConfig.setPlayerRules(ctx.player(), new Ruleset(packet.rules));
            InvTweaksConfig.setPlayerAutoRefill(ctx.player(), packet.autoRefill);
            InvTweaksConfig.setPlayerContOverrides(ctx.player(), InvTweaksConfig.cfgToCompiledContOverrides(packet.contOverrides));
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

