/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.network;

import invtweaks.InvTweaksMod;
import invtweaks.util.Sorting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public class PacketSortInv
implements CustomPacketPayload,
IPayloadHandler<PacketSortInv> {
    private final boolean isPlayer;
    private final String screenName;
    public static final CustomPacketPayload.Type<PacketSortInv> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"invtweaks", (String)"packet_sort_inv"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSortInv> CODEC = new StreamCodec<RegistryFriendlyByteBuf, PacketSortInv>(){

        public PacketSortInv decode(RegistryFriendlyByteBuf buff) {
            return new PacketSortInv(buff.readBoolean(), buff.readUtf());
        }

        public void encode(RegistryFriendlyByteBuf buffer, PacketSortInv packetSortInv) {
            buffer.writeBoolean(packetSortInv.isPlayer);
            buffer.writeUtf(packetSortInv.screenName);
        }
    };

    public PacketSortInv(boolean isPlayer, String screenClass) {
        this.isPlayer = isPlayer;
        this.screenName = screenClass;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(PacketSortInv payload, IPayloadContext context) {
        context.enqueueWork(() -> Sorting.executeSort(context.player(), payload.isPlayer, payload.screenName)).exceptionally(e -> {
            InvTweaksMod.LOGGER.error("Failed to sort inventory", e);
            return null;
        });
    }
}

