/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client.gui;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.client.gui.BaseInvitationScreen;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import dev.ftb.mods.ftbteams.net.PlayerGUIOperationMessage;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class AllyScreen
extends BaseInvitationScreen {
    private final Set<GameProfile> existingAllies = new HashSet<GameProfile>();
    private Set<GameProfile> toAdd = new HashSet<GameProfile>();
    private Set<GameProfile> toRemove = new HashSet<GameProfile>();

    public AllyScreen() {
        super((Component)Component.translatable((String)"ftbteams.gui.manage_allies"));
        this.available.forEach(knownClientPlayer -> {
            if (ClientTeamManagerImpl.getInstance().selfTeam().isAllyOrBetter(knownClientPlayer.id())) {
                this.existingAllies.add(knownClientPlayer.profile());
                this.invites.add(knownClientPlayer.profile());
            }
        });
    }

    @Override
    protected boolean shouldIncludePlayer(KnownClientPlayer player) {
        return player.online() && !ClientTeamManagerImpl.getInstance().selfTeam().isMember(player.id());
    }

    @Override
    public void setInvited(GameProfile profile, boolean invited) {
        super.setInvited(profile, invited);
        this.toRemove = Sets.difference(this.existingAllies, (Set)this.invites);
        this.toAdd = Sets.difference((Set)this.invites, this.existingAllies);
    }

    @Override
    protected BaseInvitationScreen.ExecuteButton makeExecuteButton() {
        return new BaseInvitationScreen.ExecuteButton((Component)Component.translatable((String)"gui.accept"), Icons.ADD, () -> {
            if (!this.toAdd.isEmpty()) {
                NetworkManager.sendToServer((CustomPacketPayload)PlayerGUIOperationMessage.forGameProfiles(PlayerGUIOperationMessage.Operation.ADD_ALLY, this.toAdd));
            }
            if (!this.toRemove.isEmpty()) {
                NetworkManager.sendToServer((CustomPacketPayload)PlayerGUIOperationMessage.forGameProfiles(PlayerGUIOperationMessage.Operation.REMOVE_ALLY, this.toRemove));
            }
            this.closeGui();
        }){

            public boolean isEnabled() {
                return !AllyScreen.this.toAdd.isEmpty() || !AllyScreen.this.toRemove.isEmpty();
            }
        };
    }
}

