/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.lectern;

import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.lectern.LecternUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenBookInLecternPacket(BlockPos pos, ItemStack stack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenBookInLecternPacket> TYPE = new CustomPacketPayload.Type(BCUtil.bcLoc("open_book_in_lectern"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenBookInLecternPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, OpenBookInLecternPacket::pos, (StreamCodec)ItemStack.STREAM_CODEC, OpenBookInLecternPacket::stack, OpenBookInLecternPacket::new);

    public void handle(IPayloadContext context) {
        Player player = context.player();
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (!(blockEntity instanceof LecternBlockEntity)) {
            return;
        }
        LecternBlockEntity lectern = (LecternBlockEntity)blockEntity;
        if (lectern.getBook().isEmpty()) {
            lectern.setBook(this.stack);
        }
        LecternUtil.openScreenForLectern(this.stack, player, this.pos);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

