/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.block;

import com.github.minecraftschurlimods.bibliocraft.util.block.BCBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BCItemHandler
extends ItemStackHandler {
    private final BCBlockEntity blockEntity;

    public BCItemHandler(int size, BCBlockEntity blockEntity) {
        super(size);
        this.blockEntity = blockEntity;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        BlockState state = this.blockEntity.getBlockState();
        this.blockEntity.setChanged();
        this.blockEntity.level().sendBlockUpdated(this.blockEntity.getBlockPos(), state, state, 3);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (!this.blockEntity.canPlaceItem(slot, stack)) {
            return false;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        return (stackInSlot.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) && stackInSlot.getCount() + stack.getCount() <= this.blockEntity.getMaxStackSize();
    }
}

