/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.printingtable;

import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableTankSyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class PrintingTableTank
implements IFluidHandler,
IFluidTank {
    private static final String FLUID_KEY = "fluid";
    private static final String ID_KEY = "id";
    private static final String AMOUNT_KEY = "amount";
    private static final int EXPERIENCE_MULTIPLIER = 20;
    private final PrintingTableBlockEntity blockEntity;
    private final boolean acceptAutomation;
    private Fluid fluid = Fluids.EMPTY;
    private int amount = 0;

    public PrintingTableTank(PrintingTableBlockEntity blockEntity, boolean acceptAutomation) {
        this.blockEntity = blockEntity;
        this.acceptAutomation = acceptAutomation;
    }

    public FluidStack getFluid() {
        return new FluidStack(this.fluid, this.amount);
    }

    public int getFluidAmount() {
        return this.amount;
    }

    public int getCapacity() {
        return this.blockEntity.getExperienceCost() * 20;
    }

    public boolean isFluidValid(FluidStack stack) {
        return stack.is(Tags.Fluids.EXPERIENCE);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return tank == 0 ? this.getFluid() : FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return tank == 0 ? this.getCapacity() : 0;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return tank == 0 && this.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.acceptAutomation ? this.fillManually(resource, action) : 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public int fillManually(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!resource.is(Tags.Fluids.EXPERIENCE) || this.blockEntity.isExperienceFull()) {
            return 0;
        }
        int maxAmount = Math.min(resource.getAmount(), this.blockEntity.getExperienceCost() * 20 - this.amount);
        if (action.execute()) {
            if (this.fluid.isSame(Fluids.EMPTY)) {
                this.fluid = resource.getFluid();
            }
            this.amount += maxAmount;
        }
        return maxAmount;
    }

    public void fillFromCapability(IFluidHandler capability, Fluid fluid) {
        FluidStack drain = capability.drain(new FluidStack(fluid, this.getCapacity() - this.amount), IFluidHandler.FluidAction.EXECUTE);
        if (!drain.isEmpty()) {
            this.fillManually(drain, IFluidHandler.FluidAction.EXECUTE);
            Level level = this.blockEntity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos pos = this.blockEntity.getBlockPos();
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new PrintingTableTankSyncPacket(pos, this.fluid, this.amount), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void loadAdditional(CompoundTag tag) {
        if (!tag.contains(FLUID_KEY)) {
            return;
        }
        CompoundTag fluidTag = tag.getCompound(FLUID_KEY);
        if (fluidTag.contains(ID_KEY)) {
            this.fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)tag.getString(ID_KEY)));
        }
        if (fluidTag.contains(AMOUNT_KEY)) {
            this.amount = tag.getInt(AMOUNT_KEY);
        }
    }

    public void saveAdditional(CompoundTag tag) {
        CompoundTag fluidTag = new CompoundTag();
        fluidTag.putString(ID_KEY, BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString());
        fluidTag.putInt(AMOUNT_KEY, this.amount);
        tag.put(FLUID_KEY, (Tag)fluidTag);
    }

    public int getExperience() {
        return this.amount / 20;
    }

    public void addExperience(int experience) {
        if (!this.blockEntity.isExperienceFull()) {
            this.amount += experience * 20;
            this.amount = Math.min(this.amount, this.getCapacity());
        }
    }

    public void clear() {
        this.fluid = Fluids.EMPTY;
        this.amount = 0;
    }

    public void update(PrintingTableTankSyncPacket packet) {
        this.fluid = packet.fluid();
        this.amount = packet.amount();
    }
}

