/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.printingtable;

import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableMode;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableRecipe;
import com.github.minecraftschurlimods.bibliocraft.content.printingtable.PrintingTableRecipeInput;
import com.github.minecraftschurlimods.bibliocraft.init.BCRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class PrintingTableCloningRecipe
extends PrintingTableRecipe {
    public static final MapCodec<PrintingTableCloningRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)DataComponentType.CODEC.listOf(1, 256).fieldOf("data_components").forGetter(e -> e.dataComponentTypes), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").forGetter(e -> e.ingredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(e -> e.result), (App)Codec.INT.fieldOf("duration").forGetter(e -> e.duration)).apply((Applicative)inst, PrintingTableCloningRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PrintingTableCloningRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)DataComponentType.STREAM_CODEC.apply(ByteBufCodecs.list()), e -> e.dataComponentTypes, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), e -> e.ingredients, (StreamCodec)ItemStack.STREAM_CODEC, e -> e.result, (StreamCodec)ByteBufCodecs.INT, e -> e.duration, PrintingTableCloningRecipe::new);
    protected final List<DataComponentType<?>> dataComponentTypes;
    protected final List<Ingredient> ingredients;

    public PrintingTableCloningRecipe(List<DataComponentType<?>> dataComponentTypes, List<Ingredient> ingredients, ItemStack result, int duration) {
        super(result, duration);
        this.dataComponentTypes = dataComponentTypes;
        this.ingredients = ingredients;
    }

    public boolean matches(PrintingTableRecipeInput input, Level level) {
        if (input.left().isEmpty()) {
            return false;
        }
        if (input.right().isEmpty()) {
            return false;
        }
        if (!input.right().is(this.result.getItem())) {
            return false;
        }
        if (!this.dataComponentTypes.stream().allMatch(e -> input.right().has(e))) {
            return false;
        }
        if (input.left().stream().filter(e -> e != ItemStack.EMPTY).count() != (long)this.ingredients.size()) {
            return false;
        }
        ArrayList<Ingredient> copy = new ArrayList<Ingredient>(this.ingredients);
        block0: for (int i = 0; i < input.left().size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            for (Ingredient ingredient : copy) {
                if (!ingredient.test(stack)) continue;
                copy.remove(ingredient);
                continue block0;
            }
            return false;
        }
        return copy.isEmpty();
    }

    public ItemStack assemble(PrintingTableRecipeInput input, HolderLookup.Provider registries) {
        ItemStack stack = this.result.copy();
        for (DataComponentType<?> type : this.dataComponentTypes) {
            stack.set(type, input.right().get(type));
        }
        return stack;
    }

    public RecipeSerializer<?> getSerializer() {
        return BCRecipes.PRINTING_TABLE_CLONING.get();
    }

    @Override
    public PrintingTableMode getMode() {
        return PrintingTableMode.CLONE;
    }

    public NonNullList<ItemStack> getRemainingItems(PrintingTableRecipeInput input) {
        NonNullList remainingItems = super.getRemainingItems((RecipeInput)input);
        remainingItems.set(9, (Object)input.right().copy());
        return remainingItems;
    }

    @Override
    public Pair<List<Ingredient>, Ingredient> getDisplayIngredients() {
        return Pair.of(this.ingredients, (Object)Ingredient.of((ItemStack[])new ItemStack[]{this.result}));
    }

    public static class Builder
    extends PrintingTableRecipe.Builder {
        private final List<DataComponentType<?>> dataComponentTypes = new ArrayList();
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

        public Builder(ItemStack result, int duration) {
            super(result, duration);
        }

        public Builder addDataComponentType(DataComponentType<?> type) {
            this.dataComponentTypes.add(type);
            return this;
        }

        public Builder addIngredient(Ingredient ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        @Override
        public PrintingTableRecipe build() {
            return new PrintingTableCloningRecipe(this.dataComponentTypes, List.copyOf(this.ingredients), this.result, this.duration);
        }
    }
}

