/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.fancysign;

import com.github.minecraftschurlimods.bibliocraft.content.fancysign.FancySignBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.init.BCTags;
import com.github.minecraftschurlimods.bibliocraft.util.block.BCFacingEntityBlock;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFancySignBlock
extends BCFacingEntityBlock {
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.create((String)"upside_down");
    public static final BooleanProperty WAXED = BooleanProperty.create((String)"waxed");

    public AbstractFancySignBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)WAXED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{UPSIDE_DOWN, WAXED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FancySignBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        String text;
        if (stack.is(BCTags.Items.FANCY_SIGN_WAX) && !((Boolean)state.getValue((Property)WAXED)).booleanValue()) {
            AbstractFancySignBlock.handleWaxing(true, stack, state, level, pos, player, hand);
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.canPerformAction(ItemAbilities.AXE_WAX_OFF) && ((Boolean)state.getValue((Property)WAXED)).booleanValue()) {
            AbstractFancySignBlock.handleWaxing(false, stack, state, level, pos, player, hand);
            return ItemInteractionResult.SUCCESS;
        }
        Component component = (Component)stack.get(DataComponents.CUSTOM_NAME);
        if (component != null && ("Dinnerbone".equals(text = component.getString()) || "Grumm".equals(text))) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)UPSIDE_DOWN) == false)));
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private static void handleWaxing(boolean wax, ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        BlockState newState = (BlockState)state.setValue((Property)WAXED, (Comparable)Boolean.valueOf(wax));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
        }
        if (stack.isDamageableItem()) {
            stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        } else {
            stack.shrink(1);
        }
        level.setBlockAndUpdate(pos, newState);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
        level.levelEvent(player, wax ? 3003 : 3004, pos, 0);
    }
}

