/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.api.lockandkey;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.LockCode;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface LockAndKeyBehavior<T extends BlockEntity> {
    public LockCode getLockKey(T var1);

    public void setLockKey(T var1, LockCode var2);

    public Component getDisplayName(T var1);

    public record Simple<T extends BlockEntity>(Function<T, LockCode> lockGetter, BiConsumer<T, LockCode> lockSetter, Function<T, Component> nameGetter) implements LockAndKeyBehavior<T>
    {
        @Override
        public LockCode getLockKey(T blockEntity) {
            return this.lockGetter.apply(blockEntity);
        }

        @Override
        public void setLockKey(T blockEntity, LockCode lock) {
            this.lockSetter.accept(blockEntity, lock);
        }

        @Override
        public Component getDisplayName(T blockEntity) {
            return this.nameGetter.apply(blockEntity);
        }
    }
}

