/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class TileEntityPhantomItemface
extends TileEntityPhantomface {
    public TileEntityPhantomItemface(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.PHANTOM_ITEMFACE.getTileEntityType(), pos, state);
        this.type = BlockPhantom.Type.ITEMFACE;
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomItemface) {
            TileEntityPhantomItemface tile = (TileEntityPhantomItemface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomItemface) {
            TileEntityPhantomItemface tile = (TileEntityPhantomItemface)t;
            tile.serverTick();
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation || this.isBoundThingInRange();
    }

    @Override
    public boolean isBoundThingInRange() {
        BlockEntity tile;
        if (super.isBoundThingInRange() && (tile = this.level.getBlockEntity(this.getBoundPosition())) != null) {
            for (Direction facing : Direction.values()) {
                if (this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.getBoundPosition(), (Object)facing) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IItemHandler getItemHandler(Direction facing) {
        BlockEntity tile;
        if (this.isBoundThingInRange() && (tile = this.level.getBlockEntity(this.getBoundPosition())) != null) {
            return (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.getBoundPosition(), (Object)facing);
        }
        return null;
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation || this.isBoundThingInRange();
    }
}

