/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.network.packet.ButtonToTilePacket;
import de.ellpeck.actuallyadditions.mod.network.packet.NumberToTilePacket;
import de.ellpeck.actuallyadditions.mod.network.packet.SyncPlayerPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public final class PacketHelperClient {
    public static void sendButtonPacket(BlockEntity tile, int buttonId) {
        BlockPos pos = tile.getBlockPos();
        PacketDistributor.sendToServer((CustomPacketPayload)new ButtonToTilePacket(tile.getLevel().dimension().location(), pos, Minecraft.getInstance().player.getId(), buttonId), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendPlayerDataToServer(boolean log, int type) {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Log", log);
        compound.putInt("Type", type);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            compound.putString("World", player.level().dimension().location().toString());
            compound.putUUID("UUID", player.getUUID());
            PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((Player)player);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncPlayerPacket(compound), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendNumberPacket(BlockEntity tile, double number, int id) {
        PacketDistributor.sendToServer((CustomPacketPayload)new NumberToTilePacket(tile.getLevel().dimension().location(), tile.getBlockPos(), Minecraft.getInstance().player.getId(), number, id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

