/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BannerPattern;

public final class BannerHelper {
    public static ResourceKey<BannerPattern> DRILL = BannerHelper.create("drill");
    public static ResourceKey<BannerPattern> LEAF_BLO = BannerHelper.create("leaf_blo");
    public static ResourceKey<BannerPattern> PHAN_CON = BannerHelper.create("phan_con");
    public static ResourceKey<BannerPattern> BOOK = BannerHelper.create("book");

    private static ResourceKey<BannerPattern> create(String pName) {
        return ResourceKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)ActuallyAdditions.modLoc(pName));
    }

    public static void bootstrap(BootstrapContext<BannerPattern> pContext) {
        BannerHelper.register(pContext, DRILL);
        BannerHelper.register(pContext, LEAF_BLO);
        BannerHelper.register(pContext, PHAN_CON);
        BannerHelper.register(pContext, BOOK);
    }

    public static void register(BootstrapContext<BannerPattern> pContext, ResourceKey<BannerPattern> pResourceKey) {
        pContext.register(pResourceKey, (Object)new BannerPattern(pResourceKey.location(), "block.minecraft.banner." + pResourceKey.location().toShortLanguageKey()));
    }
}

