/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.lens;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.crafting.MiningLensRecipe;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class LensMining
extends Lens {
    @Override
    public boolean invoke(BlockState hitState, BlockPos hitPos, IAtomicReconstructor tile) {
        int energyUse = (Integer)CommonConfig.Machines.MINER_LENS_ENERGY.get();
        if (!tile.getWorldObject().isEmptyBlock(hitPos)) {
            if (tile.getEnergy() >= energyUse) {
                int adaptedUse = energyUse;
                ArrayList<MiningLensRecipe> ores = new ArrayList<MiningLensRecipe>();
                Block hitBlock = hitState.getBlock();
                ItemStack item = new ItemStack((ItemLike)hitBlock.asItem());
                for (RecipeHolder<MiningLensRecipe> r : ActuallyAdditionsAPI.MINING_LENS_RECIPES) {
                    if (!((MiningLensRecipe)r.value()).matches(item)) continue;
                    ores.add((MiningLensRecipe)r.value());
                }
                if (!ores.isEmpty()) {
                    int totalWeight = WeightedRandom.getTotalWeight(ores);
                    Optional ore = WeightedRandom.getRandomItem((RandomSource)tile.getWorldObject().random, ores);
                    ItemStack stack = ore.map(recipe -> recipe.getResultItem((HolderLookup.Provider)tile.getWorldObject().registryAccess()).copy()).orElse(ItemStack.EMPTY);
                    if (!stack.isEmpty() && stack.getItem() instanceof BlockItem) {
                        Block toPlace = Block.byItem((Item)stack.getItem());
                        BlockState state2Place = toPlace.defaultBlockState();
                        tile.getWorldObject().setBlock(hitPos, state2Place, 2);
                        tile.getWorldObject().levelEvent(2001, hitPos, Block.getId((BlockState)state2Place));
                        tile.extractEnergy(adaptedUse);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int getColor() {
        return 0x4C4C4C;
    }

    @Override
    public int getDistance() {
        return 10;
    }
}

