/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.inventory.ContainerFireworkBox;
import de.ellpeck.actuallyadditions.mod.network.PacketHelperClient;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFireworkBox;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GuiFireworkBox
extends AbstractContainerScreen<ContainerFireworkBox> {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("gui_firework_box");
    protected final TileEntityFireworkBox tile;

    public GuiFireworkBox(ContainerFireworkBox screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.tile = screenContainer.fireworkbox;
        this.imageWidth = 302;
        this.imageHeight = 130;
    }

    public void init() {
        super.init();
        DecimalFormat intFormatter = new DecimalFormat("0");
        int left = this.getGuiLeft() + 2;
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 2, (Component)Component.literal((String)"Value Play"), 0.0, 5.0, this.tile.intValuePlay, intFormatter, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 0)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 23, (Component)Component.literal((String)"Average Charge Amount"), 1.0, 4.0, this.tile.chargeAmount, intFormatter, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 1)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 44, (Component)Component.literal((String)"Average Flight Time"), 1.0, 3.0, this.tile.flightTime, intFormatter, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 2)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 65, (Component)Component.literal((String)"Effect Chance"), 0.0, 1.0, this.tile.trailOrFlickerChance, null, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 3)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 86, (Component)Component.literal((String)"Flicker/Trail Ratio"), 0.0, 1.0, this.tile.flickerChance, null, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 4)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left, this.getGuiTop() + 107, (Component)Component.literal((String)"Color Amount"), 1.0, 6.0, this.tile.colorAmount, intFormatter, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 5)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 2, (Component)Component.literal((String)"Small Ball"), 0.0, 1.0, this.tile.typeChance0, null, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 6)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 23, (Component)Component.literal((String)"Large Ball"), 0.0, 1.0, this.tile.typeChance1, null, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 7)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 44, (Component)Component.literal((String)"Star Shape"), 0.0, 1.0, this.tile.typeChance2, null, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 8)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 65, (Component)Component.literal((String)"Creeper Shape"), 0.0, 1.0, this.tile.typeChance3, null, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 9)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 86, (Component)Component.literal((String)"Burst"), 0.0, 1.0, this.tile.typeChance4, null, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 10)));
        this.addRenderableWidget((GuiEventListener)new CustomSlider(left + 150, this.getGuiTop() + 107, (Component)Component.literal((String)"Area of Effect"), 0.0, 4.0, this.tile.areaOfEffect, intFormatter, slider -> PacketHelperClient.sendNumberPacket(this.tile, slider.getValue(), 11)));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        guiGraphics.drawString(this.font, this.title, (int)((float)this.getXSize() / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), -10, 0xFFFFFF, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        guiGraphics.blit(RES_LOC, this.leftPos, this.topPos, 0.0f, 0.0f, this.getXSize(), this.getYSize(), 512, 512);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.getFocused() != null && this.isDragging() && pButton == 0) {
            return this.getFocused().mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private static class CustomSlider
    extends AbstractSliderButton {
        private final double min;
        private final double max;
        private final DecimalFormat format;
        private final Component sliderName;
        private final NumberFormat defaultFormat = new DecimalFormat("0.00000000");
        protected final OnApply onApply;
        private final double stepSize = 0.0;

        public CustomSlider(int x, int y, Component message, double min, double max, double defaultValue, DecimalFormat format, OnApply onApply) {
            super(x, y, 148, 20, message, defaultValue);
            this.sliderName = message;
            this.min = min;
            this.max = max;
            this.format = format;
            this.value = (Mth.clamp((double)((float)this.value), (double)min, (double)max) - min) / (max - min);
            this.onApply = onApply;
            this.updateMessage();
        }

        protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
            super.onDrag(mouseX, mouseY, dragX, dragY);
            this.setValueFromMouse(mouseX);
        }

        private void setValueFromMouse(double mouseX) {
            this.setSliderValue((mouseX - (double)(this.getX() + 4)) / (double)(this.width - 8));
        }

        public double getValue() {
            return this.value * (this.max - this.min) + this.min;
        }

        private void setSliderValue(double value) {
            double oldValue = this.value;
            this.value = this.snapToNearest(value);
            if (!Mth.equal((double)oldValue, (double)this.value)) {
                this.applyValue();
            }
            this.updateMessage();
        }

        private double snapToNearest(double value) {
            return Mth.clamp((double)value, (double)0.0, (double)1.0);
        }

        public String getValueString() {
            if (this.format == null) {
                if (this.getValue() == (double)((int)this.getValue())) {
                    return String.valueOf((double)((int)this.getValue()));
                }
                return this.defaultFormat.format(this.getValue());
            }
            return this.format.format(this.getValue());
        }

        protected void updateMessage() {
            this.setMessage((Component)this.sliderName.copy().append(": ").append(this.getValueString()));
        }

        public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
            return super.mouseReleased(pMouseX, pMouseY, pButton);
        }

        protected void applyValue() {
            this.onApply.onApply(this);
        }

        public static interface OnApply {
            public void onApply(CustomSlider var1);
        }
    }
}

