/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class ColorChangeRecipe
implements Recipe<SingleRecipeInput> {
    public static final String NAME = "color_change";
    private final Ingredient input;
    private final ItemStack output;

    public ColorChangeRecipe(ItemStack output, Ingredient input) {
        this.input = input;
        this.output = output;
    }

    public boolean matches(@Nonnull SingleRecipeInput input, @Nonnull Level pLevel) {
        return this.input.test(input.getItem(0));
    }

    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public static Optional<RecipeHolder<ColorChangeRecipe>> getRecipeForStack(ItemStack stack) {
        return ActuallyAdditionsAPI.COLOR_CHANGE_RECIPES.stream().filter(recipe -> ((ColorChangeRecipe)recipe.value()).matches(stack)).findFirst();
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.COLOR_CHANGE_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.COLOR_CHANGE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ColorChangeRecipe> {
        private static final MapCodec<ColorChangeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input)).apply((Applicative)instance, ColorChangeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ColorChangeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ColorChangeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ColorChangeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @Nullable
        public static ColorChangeRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer);
            return new ColorChangeRecipe(result, ingredient);
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf pBuffer, ColorChangeRecipe pRecipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.input);
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.output);
        }
    }
}

