/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.blocks.blockhuds.IBlockHud;
import de.ellpeck.actuallyadditions.mod.blocks.blockhuds.PhantomHud;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomEnergyface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomItemface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomLiquiface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomPlacer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomRedstoneface;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockPhantom
extends BlockContainerBase
implements IHudDisplay {
    private static final IBlockHud HUD = new PhantomHud();
    public final Type type;

    public BlockPhantom(Type type) {
        super(ActuallyBlocks.defaultPickProps(4.5f, 10.0f));
        this.type = type;
    }

    public boolean isSignalSource(BlockState state) {
        return this.type == Type.REDSTONEFACE;
    }

    public int getSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tile;
        if (this.type == Type.REDSTONEFACE && (tile = world.getBlockEntity(pos)) instanceof TileEntityPhantomRedstoneface) {
            return ((TileEntityPhantomRedstoneface)tile).providesWeak[side.ordinal()];
        }
        return 0;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tile;
        if (this.type == Type.REDSTONEFACE && (tile = world.getBlockEntity(pos)) instanceof TileEntityPhantomRedstoneface) {
            return ((TileEntityPhantomRedstoneface)tile).providesStrong[side.ordinal()];
        }
        return 0;
    }

    @Override
    public boolean shouldDropInventory(Level world, BlockPos pos) {
        return this.type == Type.PLACER || this.type == Type.BREAKER;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        switch (this.type.ordinal()) {
            case 1: {
                return new TileEntityPhantomPlacer(pos, state);
            }
            case 2: {
                return new TileEntityPhantomBreaker(pos, state);
            }
            case 3: {
                return new TileEntityPhantomLiquiface(pos, state);
            }
            case 4: {
                return new TileEntityPhantomEnergyface(pos, state);
            }
            case 5: {
                return new TileEntityPhantomRedstoneface(pos, state);
            }
        }
        return new TileEntityPhantomItemface(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return switch (this.type.ordinal()) {
            case 1, 2 -> {
                if (level.isClientSide) {
                    yield TileEntityPhantomPlacer::clientTick;
                }
                yield TileEntityPhantomPlacer::serverTick;
            }
            case 3 -> {
                if (level.isClientSide) {
                    yield TileEntityPhantomLiquiface::clientTick;
                }
                yield TileEntityPhantomLiquiface::serverTick;
            }
            case 4 -> {
                if (level.isClientSide) {
                    yield TileEntityPhantomEnergyface::clientTick;
                }
                yield TileEntityPhantomEnergyface::serverTick;
            }
            case 5 -> {
                if (level.isClientSide) {
                    yield TileEntityPhantomRedstoneface::clientTick;
                }
                yield TileEntityPhantomRedstoneface::serverTick;
            }
            default -> level.isClientSide ? TileEntityPhantomItemface::clientTick : TileEntityPhantomItemface::serverTick;
        };
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        BlockEntity tile;
        if (this.tryToggleRedstone(world, pos, player)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!world.isClientSide && (tile = world.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)tile;
            player.openMenu(menuProvider, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    public IBlockHud getHud() {
        return HUD;
    }

    public static enum Type {
        ITEMFACE,
        PLACER,
        BREAKER,
        LIQUIFACE,
        ENERGYFACE,
        REDSTONEFACE;

    }
}

