/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import de.ellpeck.actuallyadditions.data.AdvancementGenerator;
import de.ellpeck.actuallyadditions.data.BannerPatternTagsGenerator;
import de.ellpeck.actuallyadditions.data.BlockRecipeGenerator;
import de.ellpeck.actuallyadditions.data.BlockStateGenerator;
import de.ellpeck.actuallyadditions.data.BlockTagsGenerator;
import de.ellpeck.actuallyadditions.data.CoffeeIngredientGenerator;
import de.ellpeck.actuallyadditions.data.ColorChangeGenerator;
import de.ellpeck.actuallyadditions.data.CrushingRecipeGenerator;
import de.ellpeck.actuallyadditions.data.Curios;
import de.ellpeck.actuallyadditions.data.DamageTypeTagsGenerator;
import de.ellpeck.actuallyadditions.data.DataMapGenerator;
import de.ellpeck.actuallyadditions.data.EmpoweringRecipeGenerator;
import de.ellpeck.actuallyadditions.data.FuelRecipeGenerator;
import de.ellpeck.actuallyadditions.data.GlobalLootModifierGenerator;
import de.ellpeck.actuallyadditions.data.ItemModelGenerator;
import de.ellpeck.actuallyadditions.data.ItemRecipeGenerator;
import de.ellpeck.actuallyadditions.data.ItemTagsGenerator;
import de.ellpeck.actuallyadditions.data.LaserRecipeGenerator;
import de.ellpeck.actuallyadditions.data.LootTableGenerator;
import de.ellpeck.actuallyadditions.data.MiningLensGenerator;
import de.ellpeck.actuallyadditions.data.MiscMachineRecipeGenerator;
import de.ellpeck.actuallyadditions.data.PoiTypeTagsGenerator;
import de.ellpeck.actuallyadditions.data.SoundsGenerator;
import de.ellpeck.actuallyadditions.data.StructureUpdater;
import de.ellpeck.actuallyadditions.data.patchouli.PatchouliGenerator;
import de.ellpeck.actuallyadditions.mod.gen.ActuallyBiomeModifiers;
import de.ellpeck.actuallyadditions.mod.gen.ActuallyConfiguredFeatures;
import de.ellpeck.actuallyadditions.mod.gen.ActuallyPlacedFeatures;
import de.ellpeck.actuallyadditions.mod.gen.ActuallyProcessorLists;
import de.ellpeck.actuallyadditions.mod.misc.ActuallyDamageTypes;
import de.ellpeck.actuallyadditions.mod.misc.BannerHelper;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="actuallyadditions", bus=EventBusSubscriber.Bus.MOD)
public class ActuallyAdditionsData {
    @SubscribeEvent
    public static void runGenerator(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture<RegistrySetBuilder.PatchedRegistries> patchedProvider = CompletableFuture.supplyAsync(ActuallyAdditionsData::getProvider);
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(() -> ActuallyAdditionsData.getProvider().full());
        ExistingFileHelper helper = event.getExistingFileHelper();
        BlockTagsGenerator generatorBlockTags = new BlockTagsGenerator(packOutput, lookupProvider, helper);
        generator.addProvider(true, (DataProvider)new LootTableGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new BlockRecipeGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new ItemRecipeGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)generatorBlockTags);
        generator.addProvider(true, (DataProvider)new ItemTagsGenerator(packOutput, lookupProvider, (TagsProvider<Block>)generatorBlockTags, helper));
        generator.addProvider(true, (DataProvider)new PoiTypeTagsGenerator(packOutput, lookupProvider, helper));
        generator.addProvider(true, (DataProvider)new DamageTypeTagsGenerator(packOutput, lookupProvider, helper));
        generator.addProvider(true, (DataProvider)new BannerPatternTagsGenerator(packOutput, lookupProvider, helper));
        generator.addProvider(true, (DataProvider)new BlockStateGenerator(packOutput, helper));
        generator.addProvider(true, (DataProvider)new ItemModelGenerator(packOutput, helper));
        generator.addProvider(true, (DataProvider)new AdvancementGenerator(packOutput, lookupProvider, helper));
        generator.addProvider(true, (DataProvider)new LaserRecipeGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new ColorChangeGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new EmpoweringRecipeGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CrushingRecipeGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new FuelRecipeGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new MiscMachineRecipeGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new MiningLensGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CoffeeIngredientGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new DataMapGenerator(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new SoundsGenerator(packOutput, helper));
        if (ModList.get().isLoaded("patchouli")) {
            generator.addProvider(true, (DataProvider)new PatchouliGenerator(packOutput, lookupProvider));
        }
        generator.addProvider(true, (DataProvider)new GlobalLootModifierGenerator(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, patchedProvider, Set.of("actuallyadditions")));
        generator.addProvider(true, (DataProvider)new StructureUpdater("structure", "actuallyadditions", helper, packOutput));
        generator.addProvider(true, (DataProvider)new Curios(packOutput, helper, lookupProvider));
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.DAMAGE_TYPE, context -> context.register(ActuallyDamageTypes.ATOMIC_RECONSTRUCTOR, (Object)new DamageType("actuallyadditions.atomic_reconstructor", 0.0f)));
        registryBuilder.add(Registries.CONFIGURED_FEATURE, ActuallyConfiguredFeatures::bootstrap);
        registryBuilder.add(Registries.PLACED_FEATURE, ActuallyPlacedFeatures::bootstrap);
        registryBuilder.add(Registries.PROCESSOR_LIST, ActuallyProcessorLists::bootstrap);
        registryBuilder.add(Registries.BANNER_PATTERN, BannerHelper::bootstrap);
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, ActuallyBiomeModifiers::bootstrap);
        registryBuilder.add(Registries.BIOME, $ -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }
}

