/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.network.logic;

import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.gui.list.TradeListMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TradeActionPacket(Trade trade) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TradeActionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"list_trades_action"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TradeActionPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, TradeActionPacket>(){

        public TradeActionPacket decode(RegistryFriendlyByteBuf buffer) {
            return new TradeActionPacket(Trade.readFromBuffer(buffer));
        }

        public void encode(RegistryFriendlyByteBuf buffer, TradeActionPacket packet) {
            packet.trade.writeToBuffer(buffer);
        }
    };

    public static void handle(TradeActionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                AbstractContainerMenu patt1$temp = serverPlayer.containerMenu;
                if (patt1$temp instanceof TradeListMenu) {
                    TradeListMenu menu = (TradeListMenu)patt1$temp;
                    menu.executeTradeAction(packet.trade);
                }
            }
        });
    }

    public CustomPacketPayload.Type<TradeActionPacket> type() {
        return TYPE;
    }
}

