/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.network.gui;

import de.sijo.player_trading.gui.AbstractTradeNavigationScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateMenuNotifPacket(boolean pendingMenu, boolean listMenu, boolean claimMenu) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateMenuNotifPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"update_menu_notification"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateMenuNotifPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, UpdateMenuNotifPacket>(){

        public UpdateMenuNotifPacket decode(RegistryFriendlyByteBuf buffer) {
            boolean pendingMenu = buffer.readBoolean();
            boolean listMenu = buffer.readBoolean();
            boolean claimMenu = buffer.readBoolean();
            return new UpdateMenuNotifPacket(pendingMenu, listMenu, claimMenu);
        }

        public void encode(RegistryFriendlyByteBuf buffer, UpdateMenuNotifPacket packet) {
            buffer.writeBoolean(packet.pendingMenu);
            buffer.writeBoolean(packet.listMenu);
            buffer.writeBoolean(packet.claimMenu);
        }
    };

    public static void handle(UpdateMenuNotifPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            Screen patt0$temp = minecraft.screen;
            if (patt0$temp instanceof AbstractTradeNavigationScreen) {
                AbstractTradeNavigationScreen menuescreen = (AbstractTradeNavigationScreen)patt0$temp;
                menuescreen.updateMenuNotificationState(packet.pendingMenu, packet.listMenu, packet.claimMenu);
            }
        });
    }

    public CustomPacketPayload.Type<UpdateMenuNotifPacket> type() {
        return TYPE;
    }
}

