/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.network.gui;

import de.sijo.player_trading.gui.create.CreateTradeMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncPhantomSlotPacket(int slotIndex, ItemStack itemStack, boolean clearSlot) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncPhantomSlotPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"sync_phantom_slot"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncPhantomSlotPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SyncPhantomSlotPacket>(){

        public SyncPhantomSlotPacket decode(RegistryFriendlyByteBuf buf) {
            int slotIndex = buf.readVarInt();
            boolean clearSlot = buf.readBoolean();
            ItemStack itemStack = clearSlot ? ItemStack.EMPTY : (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            return new SyncPhantomSlotPacket(slotIndex, itemStack, clearSlot);
        }

        public void encode(RegistryFriendlyByteBuf buf, SyncPhantomSlotPacket packet) {
            buf.writeVarInt(packet.slotIndex());
            buf.writeBoolean(packet.clearSlot());
            if (!packet.clearSlot()) {
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)packet.itemStack());
            }
        }
    };

    public SyncPhantomSlotPacket(int slotIndex, ItemStack itemStack) {
        this(slotIndex, itemStack, false);
    }

    public static SyncPhantomSlotPacket clear(int slotIndex) {
        return new SyncPhantomSlotPacket(slotIndex, ItemStack.EMPTY, true);
    }

    public CustomPacketPayload.Type<SyncPhantomSlotPacket> type() {
        return TYPE;
    }

    public static void handle(SyncPhantomSlotPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                AbstractContainerMenu patt1$temp = serverPlayer.containerMenu;
                if (patt1$temp instanceof CreateTradeMenu) {
                    CreateTradeMenu menu = (CreateTradeMenu)patt1$temp;
                    if (packet.clearSlot()) {
                        menu.setPhantomItem(packet.slotIndex(), ItemStack.EMPTY);
                    } else {
                        menu.setPhantomItem(packet.slotIndex(), packet.itemStack());
                    }
                }
            }
        });
    }
}

