/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.network.gui;

import de.sijo.player_trading.gui.TradeMenuType;
import de.sijo.player_trading.logic.ClaimTrade;
import de.sijo.player_trading.logic.CreateTrade;
import de.sijo.player_trading.logic.ListTrades;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NavigateMenuPacket(TradeMenuType menuType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<NavigateMenuPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"navigate_menu"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NavigateMenuPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, NavigateMenuPacket>(){

        public NavigateMenuPacket decode(RegistryFriendlyByteBuf buffer) {
            TradeMenuType menuType = (TradeMenuType)buffer.readEnum(TradeMenuType.class);
            return new NavigateMenuPacket(menuType);
        }

        public void encode(RegistryFriendlyByteBuf buffer, NavigateMenuPacket packet) {
            buffer.writeEnum((Enum)packet.menuType);
        }
    };

    public static void handle(NavigateMenuPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                switch (packet.menuType) {
                    case CLAIM_TRADES: {
                        ClaimTrade.listClaimableTradesGui((Player)serverPlayer);
                        break;
                    }
                    case LIST_TRADES: {
                        ListTrades.ListAllTrades((Player)serverPlayer);
                        break;
                    }
                    case PENDING_TRADES: {
                        ListTrades.listOwnTradesGui((Player)serverPlayer);
                        break;
                    }
                    case CREATE_TRADE: {
                        CreateTrade.createTradeGui((Player)serverPlayer);
                    }
                }
            }
        });
    }

    public CustomPacketPayload.Type<NavigateMenuPacket> type() {
        return TYPE;
    }
}

