/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.network.data_update;

import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.gui.list.TradeListMenu;
import de.sijo.player_trading.gui.list.data_provider.TradeListActionType;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderAllTrades;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderForPlayer;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderListClaim;
import de.sijo.player_trading.network.data_update.NewTradeListDataPacket;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RequestTradeListDataUpdatePacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestTradeListDataUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"refresh_trade_list"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestTradeListDataUpdatePacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, RequestTradeListDataUpdatePacket>(){

        public RequestTradeListDataUpdatePacket decode(RegistryFriendlyByteBuf buffer) {
            return new RequestTradeListDataUpdatePacket();
        }

        public void encode(RegistryFriendlyByteBuf buffer, RequestTradeListDataUpdatePacket packet) {
        }
    };

    public static void handle(RequestTradeListDataUpdatePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                AbstractContainerMenu patt1$temp = serverPlayer.containerMenu;
                if (patt1$temp instanceof TradeListMenu) {
                    TradeListMenu menu = (TradeListMenu)patt1$temp;
                    List<Trade> trades = switch (menu.getDataProvider().getTradeActionType()) {
                        default -> throw new MatchException(null, null);
                        case TradeListActionType.CLAIM_TRADE -> new TradeListDataProviderListClaim(serverPlayer.getUUID()).getTrades();
                        case TradeListActionType.CANCEL_TRADE -> new TradeListDataProviderForPlayer(serverPlayer.getName().getString()).getTrades();
                        case TradeListActionType.ACCEPT_TRADE -> new TradeListDataProviderAllTrades(serverPlayer.getName().getString()).getTrades();
                    };
                    RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), serverPlayer.registryAccess(), ConnectionType.NEOFORGE);
                    buffer.writeInt(trades.size());
                    for (Trade trade : trades) {
                        trade.writeToBuffer(buffer);
                    }
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new NewTradeListDataPacket(buffer.array()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }

    public CustomPacketPayload.Type<RequestTradeListDataUpdatePacket> type() {
        return TYPE;
    }
}

