/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.network.data_update;

import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.gui.list.TradeListScreen;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NewTradeListDataPacket(byte[] data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<NewTradeListDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"refresh_trade_list_response"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NewTradeListDataPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, NewTradeListDataPacket>(){

        public NewTradeListDataPacket decode(RegistryFriendlyByteBuf buffer) {
            int length = buffer.readInt();
            byte[] data = new byte[length];
            buffer.readBytes(data);
            return new NewTradeListDataPacket(data);
        }

        public void encode(RegistryFriendlyByteBuf buffer, NewTradeListDataPacket packet) {
            buffer.writeInt(packet.data.length);
            buffer.writeBytes(packet.data);
        }
    };

    public static void handle(NewTradeListDataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            Screen patt0$temp = minecraft.screen;
            if (patt0$temp instanceof TradeListScreen) {
                TradeListScreen tradeListScreen = (TradeListScreen)patt0$temp;
                RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])packet.data), minecraft.player.registryAccess(), ConnectionType.NEOFORGE);
                int tradeCount = buffer.readInt();
                ArrayList<Trade> trades = new ArrayList<Trade>();
                for (int i = 0; i < tradeCount; ++i) {
                    trades.add(Trade.readFromBuffer(buffer));
                }
                tradeListScreen.updateTradeData(trades);
            }
        });
    }

    public CustomPacketPayload.Type<NewTradeListDataPacket> type() {
        return TYPE;
    }
}

