/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.logic;

import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.gui.list.TradeListMenuProvider;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderAllTrades;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderForPlayer;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderForSelectedPlayer;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;

public class ListTrades {
    public static int ListAllTrades(Player player) {
        TradeListDataProviderAllTrades dataProvider = new TradeListDataProviderAllTrades(player.getName().getString());
        List<Trade> trades = dataProvider.getTrades();
        if (trades.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)"No trades found to Display").withStyle(ChatFormatting.YELLOW));
            return 0;
        }
        player.openMenu((MenuProvider)new TradeListMenuProvider(dataProvider), dataProvider::writeToBuffer);
        return 1;
    }

    public static int listTradesGuiFilteredByPlayer(Player player, String selectedPlayerName) {
        if (selectedPlayerName.equals(player.getName().getString())) {
            player.sendSystemMessage((Component)Component.literal((String)"Cannot display own Trades, Please use /trade pending for that").withStyle(ChatFormatting.YELLOW));
            return 0;
        }
        TradeListDataProviderForSelectedPlayer dataProvider = new TradeListDataProviderForSelectedPlayer(selectedPlayerName);
        List<Trade> trades = dataProvider.getTrades();
        if (trades.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)("No trades found for player: " + selectedPlayerName)).withStyle(ChatFormatting.YELLOW));
            return 0;
        }
        player.openMenu((MenuProvider)new TradeListMenuProvider(dataProvider), dataProvider::writeToBuffer);
        return 1;
    }

    public static int listOwnTradesGui(Player player) {
        TradeListDataProviderForPlayer dataProvider = new TradeListDataProviderForPlayer(player.getName().getString());
        List<Trade> trades = dataProvider.getTrades();
        if (trades.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)"You have Currently no Open Trades").withStyle(ChatFormatting.YELLOW));
            return 0;
        }
        player.openMenu((MenuProvider)new TradeListMenuProvider(dataProvider), dataProvider::writeToBuffer);
        return 1;
    }
}

