/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.logic;

import de.sijo.player_trading.PlayerTradingMod;
import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.gui.list.TradeListMenuProvider;
import de.sijo.player_trading.gui.list.data_provider.TradeListDataProviderListClaim;
import de.sijo.player_trading.logic.AbstractInventoryUtilites;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ClaimTrade
extends AbstractInventoryUtilites {
    public static int claimAll(Player player) {
        try {
            List<Trade> playerTrades = TradeRepository.getInstance().getCompletedTradesForSeller(player.getUUID());
            if (playerTrades.isEmpty()) {
                player.sendSystemMessage((Component)Component.literal((String)"No completed trades to claim!").withStyle(ChatFormatting.YELLOW));
                return 0;
            }
            int claimedCount = 0;
            for (Trade trade : playerTrades) {
                if (!ClaimTrade.claimSingleTrade(player, trade)) continue;
                ++claimedCount;
            }
            if (claimedCount > 0) {
                player.sendSystemMessage((Component)Component.literal((String)("Claimed " + claimedCount + " completed trades!")).withStyle(ChatFormatting.GREEN));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"Could not claim any trades due to insufficient inventory space!").withStyle(ChatFormatting.RED));
            }
            return claimedCount;
        }
        catch (Exception e) {
            player.sendSystemMessage((Component)Component.literal((String)("Error claiming trades: " + e.getMessage())).withStyle(ChatFormatting.RED));
            return 0;
        }
    }

    public static int claimSpecific(Player player, int tradeId) {
        try {
            Trade trade = TradeRepository.getInstance().getCompletedTradeById(tradeId);
            if (trade == null) {
                player.sendSystemMessage((Component)Component.literal((String)("Completed trade #" + tradeId + " not found!")).withStyle(ChatFormatting.RED));
                return 0;
            }
            if (!trade.offerPlayerId().equals(player.getUUID())) {
                player.sendSystemMessage((Component)Component.literal((String)"This is not your trade!").withStyle(ChatFormatting.RED));
                return 0;
            }
            if (ClaimTrade.claimSingleTrade(player, trade)) {
                player.sendSystemMessage((Component)Component.literal((String)("Claimed trade #" + tradeId + " successfully!")).withStyle(ChatFormatting.GREEN));
                return 1;
            }
            player.sendSystemMessage((Component)Component.literal((String)"Something unknown went wrong").withStyle(ChatFormatting.YELLOW));
            return 0;
        }
        catch (Exception e) {
            PlayerTradingMod.LOGGER.warn("Error claiming trade" + String.valueOf(e));
            player.sendSystemMessage((Component)Component.literal((String)("Error claiming trade: " + e.getMessage())).withStyle(ChatFormatting.RED));
            return 0;
        }
    }

    public static int listClaimableTradesGui(Player player) {
        TradeListDataProviderListClaim dataProvider = new TradeListDataProviderListClaim(player.getUUID());
        List<Trade> trades = dataProvider.getTrades();
        if (trades.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)"You have Currently no Completed Trades").withStyle(ChatFormatting.YELLOW));
            return 0;
        }
        player.openMenu((MenuProvider)new TradeListMenuProvider(dataProvider), dataProvider::writeToBuffer);
        return 1;
    }

    private static boolean claimSingleTrade(Player player, Trade trade) {
        int availableSlots;
        Map<ItemStack, Integer> itemsToAdd;
        Inventory inventory = player.getInventory();
        int requiredSlots = ClaimTrade.calculateRequiredSlots(inventory, itemsToAdd = ClaimTrade.consolidateItemStacks(trade.ItemsRequest()));
        if (requiredSlots > (availableSlots = ClaimTrade.countAvailableSlots(inventory))) {
            player.sendSystemMessage((Component)Component.literal((String)("Not enough inventory space to claim trade #" + trade.id() + "! Need " + requiredSlots + " slots but only have " + availableSlots)).withStyle(ChatFormatting.RED));
            return false;
        }
        TradeRepository.getInstance().removeTrade(trade);
        for (ItemStack item : trade.ItemsRequest()) {
            if (item == null || item.isEmpty()) continue;
            ClaimTrade.addItemToInventory(inventory, item.copy());
        }
        return true;
    }
}

