/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.logic;

import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.logic.AbstractInventoryUtilites;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CancelTrade
extends AbstractInventoryUtilites {
    public static int cancelTrade(Player player, int tradeId) {
        try {
            Trade trade = TradeRepository.getInstance().getPendingTradeById(tradeId);
            if (trade == null) {
                player.sendSystemMessage((Component)Component.literal((String)("Trade #" + tradeId + " not found!")).withStyle(ChatFormatting.RED));
                return 0;
            }
            if (!trade.offerPlayerId().equals(player.getUUID())) {
                player.sendSystemMessage((Component)Component.literal((String)"You can only cancel your own trades!").withStyle(ChatFormatting.RED));
                return 0;
            }
            if (!CancelTrade.validateInventorySpaceForReturn(player.getInventory(), trade)) {
                player.sendSystemMessage((Component)Component.literal((String)"Not enough inventory space to receive your offered items back! Free up some space and try again.").withStyle(ChatFormatting.RED));
                return 0;
            }
            if (!TradeRepository.getInstance().removePendingTrade(trade)) {
                player.sendSystemMessage((Component)Component.literal((String)("Trade #" + tradeId + " is no longer available for cancellation!")).withStyle(ChatFormatting.YELLOW));
                return 0;
            }
            CancelTrade.returnOfferedItems(player.getInventory(), trade);
            player.sendSystemMessage((Component)Component.literal((String)("Trade #" + tradeId + " has been canceled! Your offered items have been returned to your inventory.")).withStyle(ChatFormatting.GREEN));
            return 1;
        }
        catch (Exception e) {
            player.sendSystemMessage((Component)Component.literal((String)("Error canceling trade: " + e.getMessage())).withStyle(ChatFormatting.RED));
            return 0;
        }
    }

    private static Trade findTradeById(int tradeId) {
        return TradeRepository.getInstance().getTradeById(tradeId);
    }

    private static boolean validateInventorySpaceForReturn(Inventory inventory, Trade trade) {
        int availableSlots;
        Map<ItemStack, Integer> itemsToReturn = CancelTrade.consolidateItemStacks(trade.ItemsOffer());
        int requiredSlots = CancelTrade.calculateRequiredSlots(inventory, itemsToReturn);
        return requiredSlots <= (availableSlots = CancelTrade.countAvailableSlots(inventory));
    }

    private static void returnOfferedItems(Inventory inventory, Trade trade) {
        for (ItemStack offeredItem : trade.ItemsOffer()) {
            if (offeredItem == null || offeredItem.isEmpty()) continue;
            CancelTrade.addItemToInventory(inventory, offeredItem.copy());
        }
    }
}

