/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.logic;

import com.mojang.text2speech.Narrator;
import de.sijo.player_trading.PlayerTradingMod;
import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.data.persistence.PendingNotificationRepository;
import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.logic.AbstractInventoryUtilites;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AcceptTrade
extends AbstractInventoryUtilites {
    public static int acceptTrade(Player player, int tradeId) {
        try {
            Trade trade = TradeRepository.getInstance().getPendingTradeById(tradeId);
            if (trade == null) {
                player.sendSystemMessage((Component)Component.literal((String)("Trade #" + tradeId + " not found!")).withStyle(ChatFormatting.RED));
                return 0;
            }
            if (trade.offerPlayerId().equals(player.getUUID())) {
                player.sendSystemMessage((Component)Component.literal((String)"You cannot accept your own trade!").withStyle(ChatFormatting.RED));
                return 0;
            }
            InventoryValidation validation = AcceptTrade.validateInventory(player.getInventory(), trade);
            if (!validation.canComplete()) {
                player.sendSystemMessage((Component)Component.literal((String)validation.errorMessage()).withStyle(ChatFormatting.RED));
                return 0;
            }
            if (!TradeRepository.getInstance().replacePendingTrade(trade, trade.complete(player.getUUID(), player.getName().getString(), System.currentTimeMillis()))) {
                player.sendSystemMessage((Component)Component.literal((String)("Trade #" + tradeId + " is no longer available!")).withStyle(ChatFormatting.YELLOW));
                return 0;
            }
            if (AcceptTrade.executeTrade(player.getInventory(), trade)) {
                ServerPlayer seller = player.getServer().getPlayerList().getPlayer(trade.offerPlayerId());
                if (seller != null) {
                    seller.sendSystemMessage((Component)Component.literal((String)("Your trade #" + tradeId + " was completed by " + player.getName().getString() + "! Use /trade claim to receive your items.")).withStyle(ChatFormatting.GREEN));
                } else {
                    PendingNotificationRepository.getInstance().addNotification(trade.offerPlayerId(), "Your trade #" + tradeId + " was completed by " + player.getName().getString() + "! Use /trade claim to receive your items.");
                }
                player.sendSystemMessage((Component)Component.literal((String)("Trade #" + tradeId + " completed successfully!")).withStyle(ChatFormatting.GREEN));
                return 1;
            }
            PlayerTradingMod.LOGGER.error("Trade #{} execution failed for unknown reason - player {}", (Object)tradeId, (Object)player.getName().getString());
            player.sendSystemMessage((Component)Component.literal((String)"Trade execution failed!").withStyle(ChatFormatting.RED));
            return 0;
        }
        catch (Exception e) {
            Narrator.LOGGER.error("Error accepting trade #" + tradeId, (Throwable)e);
            player.sendSystemMessage((Component)Component.literal((String)("Error accepting trade: " + e.getMessage())).withStyle(ChatFormatting.RED));
            return 0;
        }
    }

    private static InventoryValidation validateInventory(Inventory inventory, Trade trade) {
        Map<ItemStack, Integer> requiredItems = AcceptTrade.consolidateItemStacks(trade.ItemsRequest());
        for (Map.Entry<ItemStack, Integer> entry : requiredItems.entrySet()) {
            ItemStack requiredItem = entry.getKey();
            int requiredCount = entry.getValue();
            int playerCount = AcceptTrade.countItemsInInventory(inventory, requiredItem);
            if (playerCount >= requiredCount) continue;
            return new InventoryValidation(false, "You need " + requiredCount + "x " + requiredItem.getHoverName().getString() + " but only have " + playerCount + "x");
        }
        int availableSlots = AcceptTrade.countAvailableSlots(inventory);
        Map<ItemStack, Integer> offeredItems = AcceptTrade.consolidateItemStacks(trade.ItemsOffer());
        int requiredSlots = AcceptTrade.calculateRequiredSlots(inventory, offeredItems);
        if (requiredSlots > availableSlots) {
            return new InventoryValidation(false, "Not enough inventory space! Need " + requiredSlots + " slots but only have " + availableSlots);
        }
        return new InventoryValidation(true, "");
    }

    private static boolean executeTrade(Inventory inventory, Trade trade) {
        try {
            Map<ItemStack, Integer> requiredItems = AcceptTrade.consolidateItemStacks(trade.ItemsRequest());
            for (Map.Entry<ItemStack, Integer> entry : requiredItems.entrySet()) {
                int countToRemove;
                ItemStack itemToRemove = entry.getKey();
                if (AcceptTrade.removeItemsFromInventory(inventory, itemToRemove, countToRemove = entry.getValue().intValue())) continue;
                return false;
            }
            for (ItemStack offeredItem : trade.ItemsOffer()) {
                if (offeredItem == null || offeredItem.isEmpty()) continue;
                AcceptTrade.addItemToInventory(inventory, offeredItem.copy());
            }
            return true;
        }
        catch (Exception e) {
            Narrator.LOGGER.info(e.getMessage());
            Narrator.LOGGER.info(e.getStackTrace().toString());
            return false;
        }
    }

    private record InventoryValidation(boolean canComplete, String errorMessage) {
    }
}

