/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.logic;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractInventoryUtilites {
    protected static final int MAIN_INVENTORY_SIZE = 36;

    protected static Map<ItemStack, Integer> consolidateItemStacks(ItemStack[] items) {
        HashMap<ItemStack, Integer> consolidated = new HashMap<ItemStack, Integer>();
        for (ItemStack stack : items) {
            if (stack == null || stack.isEmpty()) continue;
            boolean found = false;
            for (Map.Entry entry : consolidated.entrySet()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)entry.getKey()), (ItemStack)stack)) continue;
                entry.setValue((Integer)entry.getValue() + stack.getCount());
                found = true;
                break;
            }
            if (found) continue;
            ItemStack key = stack.copy();
            key.setCount(1);
            consolidated.put(key, stack.getCount());
        }
        return consolidated;
    }

    protected static int countAvailableSlots(Inventory inventory) {
        int count = 0;
        for (int i = 0; i < 36; ++i) {
            if (!inventory.getItem(i).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    protected static int calculateRequiredSlots(Inventory inventory, Map<ItemStack, Integer> itemsToAdd) {
        int requiredSlots = 0;
        for (Map.Entry<ItemStack, Integer> entry : itemsToAdd.entrySet()) {
            ItemStack item = entry.getKey();
            int totalCount = entry.getValue();
            int stackableCount = 0;
            for (int i = 0; i < 36; ++i) {
                ItemStack existingStack = inventory.getItem(i);
                if (existingStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)existingStack, (ItemStack)item)) continue;
                int maxStackSize = item.getMaxStackSize();
                int currentCount = existingStack.getCount();
                stackableCount += Math.max(0, maxStackSize - currentCount);
            }
            int remainingCount = Math.max(0, totalCount - stackableCount);
            requiredSlots += (remainingCount + item.getMaxStackSize() - 1) / item.getMaxStackSize();
        }
        return requiredSlots;
    }

    protected static void addItemToInventory(Inventory inventory, ItemStack itemToAdd) {
        int i;
        for (i = 0; i < 36; ++i) {
            int currentCount;
            int maxStackSize;
            int canAdd;
            ItemStack existingStack = inventory.getItem(i);
            if (existingStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)existingStack, (ItemStack)itemToAdd) || (canAdd = (maxStackSize = itemToAdd.getMaxStackSize()) - (currentCount = existingStack.getCount())) <= 0) continue;
            int toAdd = Math.min(canAdd, itemToAdd.getCount());
            existingStack.grow(toAdd);
            itemToAdd.shrink(toAdd);
            if (!itemToAdd.isEmpty()) continue;
            return;
        }
        for (i = 0; i < 36 && !itemToAdd.isEmpty(); ++i) {
            if (!inventory.getItem(i).isEmpty()) continue;
            inventory.setItem(i, itemToAdd.copy());
            itemToAdd.setCount(0);
            return;
        }
    }

    protected static int countItemsInInventory(Inventory inventory, ItemStack targetItem) {
        int count = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)targetItem)) continue;
            count += stack.getCount();
        }
        return count;
    }

    protected static boolean removeItemsFromInventory(Inventory inventory, ItemStack targetItem, int countToRemove) {
        int remaining = countToRemove;
        for (int i = 0; i < 36 && remaining > 0; ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)targetItem)) continue;
            int removeFromThisStack = Math.min(remaining, stack.getCount());
            stack.shrink(removeFromThisStack);
            remaining -= removeFromThisStack;
        }
        return remaining == 0;
    }
}

