/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.slot;

import de.sijo.player_trading.gui.create.CreateTradeMenu;
import de.sijo.player_trading.gui.create.CreateTradeScreen;
import de.sijo.player_trading.gui.slot.PhantomSlot;
import de.sijo.player_trading.network.gui.SyncPhantomSlotPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

@JeiPlugin
public class PhantomSlotJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"player_trading", (String)"create_trade");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CreateTradeScreen.class, (IGuiContainerHandler)new CreateTradeGuiContainerHandler());
        registration.addGhostIngredientHandler(CreateTradeScreen.class, (IGhostIngredientHandler)new CreateTradeGhostIngredientHandler());
    }

    private static class CreateTradeGuiContainerHandler
    implements IGuiContainerHandler<CreateTradeScreen> {
        private CreateTradeGuiContainerHandler() {
        }

        public List<Rect2i> getGuiExtraAreas(CreateTradeScreen containerScreen) {
            return List.of();
        }
    }

    private static class CreateTradeGhostIngredientHandler
    implements IGhostIngredientHandler<CreateTradeScreen> {
        private CreateTradeGhostIngredientHandler() {
        }

        public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(CreateTradeScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
            if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
                ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
                for (Slot slot : ((CreateTradeMenu)gui.getMenu()).slots) {
                    if (!(slot instanceof PhantomSlot)) continue;
                    targets.add(new SlotTarget(gui, slot));
                }
                return targets;
            }
            return Collections.emptyList();
        }

        public void onComplete() {
        }

        private static class SlotTarget
        implements IGhostIngredientHandler.Target<ItemStack> {
            private Slot slot;
            private Rect2i area;
            private CreateTradeScreen gui;

            public SlotTarget(CreateTradeScreen gui, Slot slot) {
                this.slot = slot;
                this.gui = gui;
                this.area = new Rect2i(gui.getGuiLeft() + slot.x, gui.getGuiTop() + slot.y, 16, 16);
            }

            public Rect2i getArea() {
                return this.area;
            }

            public void accept(ItemStack ingredient) {
                Slot slot = this.slot;
                if (slot instanceof PhantomSlot) {
                    PhantomSlot phantomSlot = (PhantomSlot)slot;
                    ItemStack template = ingredient.copy();
                    template.setCount(1);
                    ((CreateTradeMenu)this.gui.getMenu()).setPhantomItem(phantomSlot.getContainerSlot(), template);
                    PacketDistributor.sendToServer((CustomPacketPayload)new SyncPhantomSlotPacket(phantomSlot.getContainerSlot(), template), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

