/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.slot;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PhantomSlot
extends Slot {
    public PhantomSlot(Container container, int slotIndex, int posX, int posY) {
        super(container, slotIndex, posX, posY);
    }

    public boolean mayPickup(Player player) {
        return false;
    }

    public boolean mayPlace(ItemStack itemStack) {
        return true;
    }

    public void increaseCount(int amount) {
        ItemStack current = this.getItem();
        if (!current.isEmpty()) {
            int newCount = Math.min(current.getCount() + amount, current.getMaxStackSize());
            current.setCount(newCount);
        }
    }

    public void decreaseCount(int amount) {
        ItemStack current = this.getItem();
        if (!current.isEmpty()) {
            int newCount = current.getCount() - amount;
            if (newCount <= 0) {
                current.setCount(1);
            } else {
                current.setCount(newCount);
            }
        }
    }

    public void clearPhantomItem() {
        this.set(ItemStack.EMPTY);
    }

    public void setAmount(int amount) {
        ItemStack current = this.getItem();
        if (!current.isEmpty()) {
            int validAmount = Math.max(1, Math.min(amount, current.getMaxStackSize()));
            current.setCount(validAmount);
        }
    }
}

