/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.list.data_provider;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.gui.list.data_provider.AbstractTradeListDataProvider;
import de.sijo.player_trading.gui.list.data_provider.TradeListActionType;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;

public class TradeListDataProviderListClaim
extends AbstractTradeListDataProvider {
    private final UUID playerUUID;

    public TradeListDataProviderListClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        this.playerUUID = ((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID();
    }

    public TradeListDataProviderListClaim(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Override
    public List<Trade> getTrades() {
        return TradeRepository.getInstance().getCompletedTradesForSeller(this.playerUUID);
    }

    @Override
    public String getDisplayName() {
        return "Completed Trades";
    }

    @Override
    public String getButtonTooltip() {
        return "Claim Trade";
    }

    @Override
    public TradeListActionType getTradeActionType() {
        return TradeListActionType.CLAIM_TRADE;
    }
}

