/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.list.data_provider;

import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.data.persistence.TradeRepository;
import de.sijo.player_trading.gui.list.data_provider.AbstractTradeListDataProvider;
import de.sijo.player_trading.gui.list.data_provider.TradeListActionType;
import java.util.List;

public class TradeListDataProviderForSelectedPlayer
extends AbstractTradeListDataProvider {
    private final String selectedPlayerName;

    public TradeListDataProviderForSelectedPlayer(String selectedPlayerName) {
        this.selectedPlayerName = selectedPlayerName;
    }

    @Override
    public List<Trade> getTrades() {
        return TradeRepository.getInstance().getAllPendingTrades().stream().filter(x -> this.selectedPlayerName.equals(x.offerPlayerName())).toList();
    }

    @Override
    public String getDisplayName() {
        return "List Trades";
    }

    @Override
    public String getButtonTooltip() {
        return "Accept Trade";
    }

    @Override
    public TradeListActionType getTradeActionType() {
        return TradeListActionType.ACCEPT_TRADE;
    }
}

