/*
 * Decompiled with CFR 0.152.
 */
package de.sijo.player_trading.gui.list.data_provider;

import de.sijo.player_trading.data.model.Trade;
import de.sijo.player_trading.gui.list.data_provider.AbstractTradeListDataProvider;
import de.sijo.player_trading.gui.list.data_provider.TradeListActionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class TradeListDataProviderDeserialize
extends AbstractTradeListDataProvider {
    protected final String displayName;
    protected final String buttonText;
    private final TradeListActionType actionType;
    private final List<Trade> trades;

    public TradeListDataProviderDeserialize(RegistryFriendlyByteBuf buffer) {
        this.displayName = buffer.readUtf();
        this.buttonText = buffer.readUtf();
        this.actionType = (TradeListActionType)buffer.readEnum(TradeListActionType.class);
        int tradeCount = buffer.readInt();
        this.trades = new ArrayList<Trade>();
        for (int i = 0; i < tradeCount; ++i) {
            this.trades.add(Trade.readFromBuffer(buffer));
        }
    }

    @Override
    public List<Trade> getTrades() {
        return Collections.unmodifiableList(this.trades);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getButtonTooltip() {
        return this.buttonText;
    }

    @Override
    public TradeListActionType getTradeActionType() {
        return this.actionType;
    }
}

